/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.updateby.spec;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.api.updateby.spec.ImmutableRollingFormulaSpec;
import io.deephaven.api.updateby.spec.RollingOpSpec;
import io.deephaven.api.updateby.spec.UpdateBySpec;
import io.deephaven.api.updateby.spec.WindowScale;
import java.time.Duration;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class RollingFormulaSpec
extends RollingOpSpec {
    public abstract String formula();

    public abstract String paramToken();

    public static RollingFormulaSpec ofTicks(long revTicks, String formula, String paramToken) {
        return RollingFormulaSpec.of(WindowScale.ofTicks(revTicks), formula, paramToken);
    }

    public static RollingFormulaSpec ofTicks(long revTicks, long fwdTicks, String formula, String paramToken) {
        return RollingFormulaSpec.of(WindowScale.ofTicks(revTicks), WindowScale.ofTicks(fwdTicks), formula, paramToken);
    }

    public static RollingFormulaSpec ofTime(String timestampCol, Duration revDuration, String formula, String paramToken) {
        return RollingFormulaSpec.of(WindowScale.ofTime(timestampCol, revDuration), formula, paramToken);
    }

    public static RollingFormulaSpec ofTime(String timestampCol, Duration revDuration, Duration fwdDuration, String formula, String paramToken) {
        return RollingFormulaSpec.of(WindowScale.ofTime(timestampCol, revDuration), WindowScale.ofTime(timestampCol, fwdDuration), formula, paramToken);
    }

    public static RollingFormulaSpec ofTime(String timestampCol, long revDuration, String formula, String paramToken) {
        return RollingFormulaSpec.of(WindowScale.ofTime(timestampCol, revDuration), formula, paramToken);
    }

    public static RollingFormulaSpec ofTime(String timestampCol, long revDuration, long fwdDuration, String formula, String paramToken) {
        return RollingFormulaSpec.of(WindowScale.ofTime(timestampCol, revDuration), WindowScale.ofTime(timestampCol, fwdDuration), formula, paramToken);
    }

    public static RollingFormulaSpec of(WindowScale revWindowScale, String formula, String paramToken) {
        return ImmutableRollingFormulaSpec.builder().revWindowScale(revWindowScale).formula(formula).paramToken(paramToken).build();
    }

    public static RollingFormulaSpec of(WindowScale revWindowScale, WindowScale fwdWindowScale, String formula, String paramToken) {
        return ImmutableRollingFormulaSpec.builder().revWindowScale(revWindowScale).fwdWindowScale(fwdWindowScale).formula(formula).paramToken(paramToken).build();
    }

    @Override
    public final boolean applicableTo(Class<?> inputType) {
        return true;
    }

    @Override
    public final <T> T walk(UpdateBySpec.Visitor<T> visitor) {
        return visitor.visit(this);
    }

    @Value.Check
    final void checkFormula() {
        if (this.formula().isEmpty()) {
            throw new IllegalArgumentException("formula must not be empty");
        }
    }

    @Value.Check
    final void checkParamToken() {
        if (this.paramToken().isEmpty()) {
            throw new IllegalArgumentException("paramToken must not be empty");
        }
    }
}

