/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.api.updateby.spec;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.api.updateby.spec.ImmutableRollingWAvgSpec;
import io.deephaven.api.updateby.spec.RollingOpSpec;
import io.deephaven.api.updateby.spec.UpdateBySpec;
import io.deephaven.api.updateby.spec.WindowScale;
import java.time.Duration;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class RollingWAvgSpec
extends RollingOpSpec {
    public abstract String weightCol();

    public static RollingWAvgSpec ofTicks(long revTicks, String weightCol) {
        return RollingWAvgSpec.of(WindowScale.ofTicks(revTicks), weightCol);
    }

    public static RollingWAvgSpec ofTicks(long revTicks, long fwdTicks, String weightCol) {
        return RollingWAvgSpec.of(WindowScale.ofTicks(revTicks), WindowScale.ofTicks(fwdTicks), weightCol);
    }

    public static RollingWAvgSpec ofTime(String timestampCol, Duration revDuration, String weightCol) {
        return RollingWAvgSpec.of(WindowScale.ofTime(timestampCol, revDuration), weightCol);
    }

    public static RollingWAvgSpec ofTime(String timestampCol, Duration revDuration, Duration fwdDuration, String weightCol) {
        return RollingWAvgSpec.of(WindowScale.ofTime(timestampCol, revDuration), WindowScale.ofTime(timestampCol, fwdDuration), weightCol);
    }

    public static RollingWAvgSpec ofTime(String timestampCol, long revDuration, String weightCol) {
        return RollingWAvgSpec.of(WindowScale.ofTime(timestampCol, revDuration), weightCol);
    }

    public static RollingWAvgSpec ofTime(String timestampCol, long revDuration, long fwdDuration, String weightCol) {
        return RollingWAvgSpec.of(WindowScale.ofTime(timestampCol, revDuration), WindowScale.ofTime(timestampCol, fwdDuration), weightCol);
    }

    public static RollingWAvgSpec of(WindowScale revWindowScale, String weightCol) {
        return ImmutableRollingWAvgSpec.builder().weightCol(weightCol).revWindowScale(revWindowScale).build();
    }

    public static RollingWAvgSpec of(WindowScale revWindowScale, WindowScale fwdWindowScale, String weightCol) {
        return ImmutableRollingWAvgSpec.builder().weightCol(weightCol).revWindowScale(revWindowScale).fwdWindowScale(fwdWindowScale).build();
    }

    @Override
    public final boolean applicableTo(Class<?> inputType) {
        return RollingWAvgSpec.applicableToNumeric(inputType) || inputType == Character.TYPE || inputType == Character.class;
    }

    public final boolean weightColumnApplicableTo(Class<?> inputType) {
        return RollingWAvgSpec.applicableToNumeric(inputType) || inputType == Character.TYPE || inputType == Character.class;
    }

    @Override
    public final <T> T walk(UpdateBySpec.Visitor<T> visitor) {
        return visitor.visit(this);
    }
}

