/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.uri;

import io.deephaven.uri.DeephavenTarget;
import java.util.ArrayList;
import java.util.Objects;
import java.util.OptionalInt;
import org.immutables.value.Generated;

@Generated(from="DeephavenTarget", generator="Immutables")
final class ImmutableDeephavenTarget
extends DeephavenTarget {
    private final boolean isSecure;
    private final String host;
    private final Integer port;

    private ImmutableDeephavenTarget(Builder builder) {
        this.isSecure = builder.isSecure;
        this.host = builder.host;
        this.port = builder.port;
    }

    @Override
    public boolean isSecure() {
        return this.isSecure;
    }

    @Override
    public String host() {
        return this.host;
    }

    @Override
    public OptionalInt port() {
        return this.port != null ? OptionalInt.of(this.port) : OptionalInt.empty();
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDeephavenTarget && this.equalTo(0, (ImmutableDeephavenTarget)another);
    }

    private boolean equalTo(int synthetic, ImmutableDeephavenTarget another) {
        return this.isSecure == another.isSecure && this.host.equals(another.host) && Objects.equals(this.port, another.port);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.getClass().hashCode();
        h += (h << 5) + Boolean.hashCode(this.isSecure);
        h += (h << 5) + this.host.hashCode();
        h += (h << 5) + Objects.hashCode(this.port);
        return h;
    }

    private static ImmutableDeephavenTarget validate(ImmutableDeephavenTarget instance) {
        instance.checkHostPort();
        return instance;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DeephavenTarget", generator="Immutables")
    public static final class Builder
    implements DeephavenTarget.Builder {
        private static final long INIT_BIT_IS_SECURE = 1L;
        private static final long INIT_BIT_HOST = 2L;
        private static final long OPT_BIT_PORT = 1L;
        private long initBits = 3L;
        private long optBits;
        private boolean isSecure;
        private String host;
        private Integer port;

        private Builder() {
        }

        @Override
        public final Builder isSecure(boolean isSecure) {
            Builder.checkNotIsSet(this.isSecureIsSet(), "isSecure");
            this.isSecure = isSecure;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        public final Builder host(String host) {
            Builder.checkNotIsSet(this.hostIsSet(), "host");
            this.host = Objects.requireNonNull(host, "host");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        public final Builder port(int port) {
            Builder.checkNotIsSet(this.portIsSet(), "port");
            this.port = port;
            this.optBits |= 1L;
            return this;
        }

        public final Builder port(OptionalInt port) {
            Builder.checkNotIsSet(this.portIsSet(), "port");
            this.port = port.isPresent() ? Integer.valueOf(port.getAsInt()) : null;
            this.optBits |= 1L;
            return this;
        }

        @Override
        public ImmutableDeephavenTarget build() {
            this.checkRequiredAttributes();
            return ImmutableDeephavenTarget.validate(new ImmutableDeephavenTarget(this));
        }

        private boolean portIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean isSecureIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean hostIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private static void checkNotIsSet(boolean isSet, String name) {
            if (isSet) {
                throw new IllegalStateException("Builder of DeephavenTarget is strict, attribute is already set: ".concat(name));
            }
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.isSecureIsSet()) {
                attributes.add("isSecure");
            }
            if (!this.hostIsSet()) {
                attributes.add("host");
            }
            return "Cannot build DeephavenTarget, some of required attributes are not set " + attributes;
        }
    }
}

