/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.uri;

import io.deephaven.uri.ApplicationUri;
import io.deephaven.uri.DeephavenTarget;
import io.deephaven.uri.RemoteUri;
import io.deephaven.uri.UriHelper;
import java.net.URI;
import java.util.regex.Matcher;

class RemoteApplicationUri {
    RemoteApplicationUri() {
    }

    static boolean isWellFormed(URI uri) {
        return RemoteUri.isValidScheme(uri.getScheme()) && UriHelper.isRemotePath(uri) && ApplicationUri.PATH_PATTERN.matcher(uri.getPath()).matches();
    }

    static RemoteUri of(URI uri) {
        if (!RemoteApplicationUri.isWellFormed(uri)) {
            throw new IllegalArgumentException();
        }
        Matcher matcher = ApplicationUri.PATH_PATTERN.matcher(uri.getPath());
        if (!matcher.matches()) {
            throw new IllegalStateException();
        }
        String appId = matcher.group(1);
        String fieldName = matcher.group(2);
        ApplicationUri applicationUri = ApplicationUri.of(appId, fieldName);
        return RemoteUri.of(DeephavenTarget.from(uri), applicationUri);
    }

    static String toString(DeephavenTarget target, ApplicationUri applicationUri) {
        return String.format("%s/%s/%s/%s/%s", target, "app", applicationUri.applicationId(), "field", applicationUri.fieldName());
    }
}

