/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.uri;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;

public class UriHelper {
    public static boolean isUriSafe(String part) {
        String encoded;
        try {
            encoded = URLEncoder.encode(part, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
        return part.equals(encoded);
    }

    public static boolean isLocalPath(URI uri) {
        return uri.getHost() == null && !uri.isOpaque() && uri.getPath().startsWith("/") && uri.getQuery() == null && uri.getUserInfo() == null && uri.getFragment() == null;
    }

    public static boolean isRemotePath(URI uri) {
        return uri.getHost() != null && !uri.isOpaque() && uri.getPath().startsWith("/") && uri.getQuery() == null && uri.getUserInfo() == null && uri.getFragment() == null;
    }

    public static boolean isRemoteTarget(URI uri) {
        return uri.getHost() != null && !uri.isOpaque() && uri.getPath().isEmpty() && uri.getQuery() == null && uri.getUserInfo() == null && uri.getFragment() == null;
    }

    public static boolean isRemoteQuery(URI uri) {
        return uri.getHost() != null && !uri.isOpaque() && uri.getPath().isEmpty() && uri.getQuery() != null && uri.getUserInfo() == null && uri.getFragment() == null;
    }
}

