/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.uri;

import io.deephaven.annotations.SimpleStyle;
import io.deephaven.uri.DeephavenUriBase;
import io.deephaven.uri.ImmutableFieldUri;
import io.deephaven.uri.StructuredUri;
import io.deephaven.uri.UriHelper;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.immutables.value.Value;

@Value.Immutable
@SimpleStyle
public abstract class FieldUri
extends DeephavenUriBase {
    public static final Pattern PATH_PATTERN = Pattern.compile("^/field/(.+)$");

    public static FieldUri of(String fieldName) {
        return ImmutableFieldUri.of(fieldName);
    }

    public static boolean isValidScheme(String scheme) {
        return "dh".equals(scheme);
    }

    public static boolean isWellFormed(URI uri) {
        return FieldUri.isValidScheme(uri.getScheme()) && UriHelper.isLocalPath(uri) && PATH_PATTERN.matcher(uri.getPath()).matches();
    }

    public static FieldUri of(URI uri) {
        if (!FieldUri.isWellFormed(uri)) {
            throw new IllegalArgumentException(String.format("Invalid field URI '%s'", uri));
        }
        Matcher matcher = PATH_PATTERN.matcher(uri.getPath());
        if (!matcher.matches()) {
            throw new IllegalStateException();
        }
        return FieldUri.of(matcher.group(1));
    }

    @Value.Parameter
    public abstract String fieldName();

    @Override
    public final <V extends StructuredUri.Visitor> V walk(V visitor) {
        visitor.visit(this);
        return visitor;
    }

    @Override
    public final String toString() {
        return String.format("%s:///%s/%s", "dh", "field", this.fieldName());
    }

    @Value.Check
    final void checkFieldName() {
        if (!UriHelper.isUriSafe(this.fieldName())) {
            throw new IllegalArgumentException(String.format("Invalid field name '%s'", this.fieldName()));
        }
    }
}

