/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.uri;

import io.deephaven.annotations.SimpleStyle;
import io.deephaven.uri.DeephavenUriBase;
import io.deephaven.uri.ImmutableApplicationUri;
import io.deephaven.uri.StructuredUri;
import io.deephaven.uri.UriHelper;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.immutables.value.Value;

@Value.Immutable
@SimpleStyle
public abstract class ApplicationUri
extends DeephavenUriBase {
    public static final String APPLICATION = "app";
    public static final String FIELD = "field";
    public static final Pattern PATH_PATTERN = Pattern.compile("^/app/(.+)/field/(.+)$");

    public static ApplicationUri of(String applicationId, String fieldName) {
        return ImmutableApplicationUri.of(applicationId, fieldName);
    }

    public static boolean isValidScheme(String scheme) {
        return "dh".equals(scheme);
    }

    public static boolean isWellFormed(URI uri) {
        return ApplicationUri.isValidScheme(uri.getScheme()) && UriHelper.isLocalPath(uri) && PATH_PATTERN.matcher(uri.getPath()).matches();
    }

    public static ApplicationUri of(URI uri) {
        if (!ApplicationUri.isWellFormed(uri)) {
            throw new IllegalArgumentException(String.format("Invalid application URI '%s'", uri));
        }
        Matcher matcher = PATH_PATTERN.matcher(uri.getPath());
        if (!matcher.matches()) {
            throw new IllegalStateException();
        }
        String appId = matcher.group(1);
        String fieldName = matcher.group(2);
        return ApplicationUri.of(appId, fieldName);
    }

    @Value.Parameter
    public abstract String applicationId();

    @Value.Parameter
    public abstract String fieldName();

    @Override
    public final <V extends StructuredUri.Visitor> V walk(V visitor) {
        visitor.visit(this);
        return visitor;
    }

    @Override
    public final String toString() {
        return String.format("%s:///%s/%s/%s/%s", "dh", APPLICATION, this.applicationId(), FIELD, this.fieldName());
    }

    @Value.Check
    final void checkApplicationId() {
        if (!UriHelper.isUriSafe(this.applicationId())) {
            throw new IllegalArgumentException(String.format("Invalid application id '%s'", this.applicationId()));
        }
    }

    @Value.Check
    final void checkFieldName() {
        if (!UriHelper.isUriSafe(this.fieldName())) {
            throw new IllegalArgumentException(String.format("Invalid field name '%s'", this.fieldName()));
        }
    }
}

