/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.uri;

import io.deephaven.annotations.SimpleStyle;
import io.deephaven.uri.DeephavenUri;
import io.deephaven.uri.ImmutableCustomUri;
import io.deephaven.uri.StructuredUri;
import io.deephaven.uri.StructuredUriBase;
import java.net.URI;
import org.immutables.value.Value;

@Value.Immutable
@SimpleStyle
public abstract class CustomUri
extends StructuredUriBase {
    public static boolean isValidScheme(String scheme) {
        return scheme != null && !DeephavenUri.isValidScheme(scheme);
    }

    public static CustomUri of(URI uri) {
        return ImmutableCustomUri.of(uri);
    }

    @Value.Parameter
    public abstract URI uri();

    @Override
    public final URI toURI() {
        return this.uri();
    }

    @Override
    public final <V extends StructuredUri.Visitor> V walk(V visitor) {
        visitor.visit(this.uri());
        return visitor;
    }

    @Override
    public final String toString() {
        return this.uri().toString();
    }

    @Value.Check
    final void checkScheme() {
        if (!CustomUri.isValidScheme(this.uri().getScheme())) {
            throw new IllegalArgumentException(String.format("Invalid custom URI '%s'", this.uri()));
        }
    }
}

