/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.uri;

import io.deephaven.annotations.BuildableStyle;
import io.deephaven.uri.DeephavenUri;
import io.deephaven.uri.ImmutableDeephavenTarget;
import io.deephaven.uri.UriHelper;
import java.net.URI;
import java.util.OptionalInt;
import org.immutables.value.Value;

@Value.Immutable
@BuildableStyle
public abstract class DeephavenTarget {
    public static Builder builder() {
        return ImmutableDeephavenTarget.builder();
    }

    public static boolean isValidScheme(String scheme) {
        return DeephavenUri.isValidScheme(scheme);
    }

    public static boolean isWellFormed(URI uri) {
        return DeephavenTarget.isValidScheme(uri.getScheme()) && UriHelper.isRemoteTarget(uri);
    }

    public static DeephavenTarget of(URI targetUri) {
        if (!DeephavenTarget.isWellFormed(targetUri)) {
            throw new IllegalArgumentException(String.format("Invalid target Deephaven URI '%s'", targetUri));
        }
        return DeephavenTarget.from(targetUri);
    }

    public static DeephavenTarget from(URI uri) {
        String scheme = uri.getScheme();
        int port = uri.getPort();
        Builder builder = DeephavenTarget.builder().host(uri.getHost());
        switch (scheme) {
            case "dh": {
                builder.isSecure(true);
                break;
            }
            case "dh+plain": {
                builder.isSecure(false);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Invalid Deephaven target scheme '%s'", scheme));
            }
        }
        if (port != -1) {
            builder.port(port);
        }
        return builder.build();
    }

    public abstract boolean isSecure();

    public abstract String host();

    public abstract OptionalInt port();

    public final URI toURI() {
        return URI.create(this.toString());
    }

    @Value.Check
    final void checkHostPort() {
        if (!this.host().equals(this.toURI().getHost())) {
            throw new IllegalArgumentException(String.format("Invalid host '%s'", this.host()));
        }
    }

    public final String toString() {
        String scheme = this.isSecure() ? "dh" : "dh+plain";
        return this.port().isPresent() ? String.format("%s://%s:%d", scheme, this.host(), this.port().getAsInt()) : String.format("%s://%s", scheme, this.host());
    }

    public static interface Builder {
        public Builder host(String var1);

        public Builder port(int var1);

        public Builder isSecure(boolean var1);

        public DeephavenTarget build();
    }
}

