/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.uri;

import io.deephaven.annotations.SimpleStyle;
import io.deephaven.uri.DeephavenUriBase;
import io.deephaven.uri.ImmutableQueryScopeUri;
import io.deephaven.uri.StructuredUri;
import io.deephaven.uri.UriHelper;
import java.net.URI;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.immutables.value.Value;

@Value.Immutable
@SimpleStyle
public abstract class QueryScopeUri
extends DeephavenUriBase {
    public static final String SCOPE = "scope";
    public static final Pattern PATH_PATTERN = Pattern.compile("^/scope/(.+)$");

    public static QueryScopeUri of(String variableName) {
        return ImmutableQueryScopeUri.of(variableName);
    }

    public static boolean isValidScheme(String scheme) {
        return "dh".equals(scheme);
    }

    public static boolean isWellFormed(URI uri) {
        return QueryScopeUri.isValidScheme(uri.getScheme()) && UriHelper.isLocalPath(uri) && PATH_PATTERN.matcher(uri.getPath()).matches();
    }

    public static QueryScopeUri of(URI uri) {
        if (!QueryScopeUri.isWellFormed(uri)) {
            throw new IllegalArgumentException(String.format("Invalid query scope URI '%s'", uri));
        }
        Matcher matcher = PATH_PATTERN.matcher(uri.getPath());
        if (!matcher.matches()) {
            throw new IllegalStateException();
        }
        return QueryScopeUri.of(matcher.group(1));
    }

    @Value.Parameter
    public abstract String variableName();

    @Override
    public final <V extends StructuredUri.Visitor> V walk(V visitor) {
        visitor.visit(this);
        return visitor;
    }

    @Override
    public final String toString() {
        return String.format("%s:///%s/%s", "dh", SCOPE, this.variableName());
    }

    @Value.Check
    final void checkVariableName() {
        if (!UriHelper.isUriSafe(this.variableName())) {
            throw new IllegalArgumentException(String.format("Invalid variable name '%s'", this.variableName()));
        }
    }
}

