/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.uri;

import io.deephaven.uri.DeephavenTarget;
import io.deephaven.uri.FieldUri;
import io.deephaven.uri.RemoteUri;
import io.deephaven.uri.UriHelper;
import java.net.URI;
import java.util.regex.Matcher;

class RemoteFieldUri {
    RemoteFieldUri() {
    }

    static boolean isWellFormed(URI uri) {
        return RemoteUri.isValidScheme(uri.getScheme()) && UriHelper.isRemotePath(uri) && FieldUri.PATH_PATTERN.matcher(uri.getPath()).matches();
    }

    static RemoteUri of(URI uri) {
        if (!RemoteFieldUri.isWellFormed(uri)) {
            throw new IllegalArgumentException();
        }
        Matcher matcher = FieldUri.PATH_PATTERN.matcher(uri.getPath());
        if (!matcher.matches()) {
            throw new IllegalStateException();
        }
        String fieldName = matcher.group(1);
        FieldUri fieldUri = FieldUri.of(fieldName);
        return RemoteUri.of(DeephavenTarget.from(uri), fieldUri);
    }

    static String toString(DeephavenTarget target, FieldUri fieldUri) {
        return String.format("%s/%s/%s", target, "field", fieldUri.fieldName());
    }
}

