/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.uri;

import io.deephaven.uri.DeephavenTarget;
import io.deephaven.uri.QueryScopeUri;
import io.deephaven.uri.RemoteUri;
import io.deephaven.uri.UriHelper;
import java.net.URI;
import java.util.regex.Matcher;

class RemoteQueryScopeUri {
    RemoteQueryScopeUri() {
    }

    static boolean isWellFormed(URI uri) {
        return RemoteUri.isValidScheme(uri.getScheme()) && UriHelper.isRemotePath(uri) && QueryScopeUri.PATH_PATTERN.matcher(uri.getPath()).matches();
    }

    static RemoteUri of(URI uri) {
        if (!RemoteQueryScopeUri.isWellFormed(uri)) {
            throw new IllegalArgumentException();
        }
        Matcher matcher = QueryScopeUri.PATH_PATTERN.matcher(uri.getPath());
        if (!matcher.matches()) {
            throw new IllegalStateException();
        }
        String variableName = matcher.group(1);
        QueryScopeUri queryScopeUri = QueryScopeUri.of(variableName);
        return RemoteUri.of(DeephavenTarget.from(uri), queryScopeUri);
    }

    static String toString(DeephavenTarget target, QueryScopeUri uri) {
        return String.format("%s/%s/%s", target, "scope", uri.variableName());
    }
}

