/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.uri;

import io.deephaven.annotations.SimpleStyle;
import io.deephaven.uri.ApplicationUri;
import io.deephaven.uri.DeephavenTarget;
import io.deephaven.uri.DeephavenUriBase;
import io.deephaven.uri.FieldUri;
import io.deephaven.uri.ImmutableRemoteUri;
import io.deephaven.uri.QueryScopeUri;
import io.deephaven.uri.RemoteApplicationUri;
import io.deephaven.uri.RemoteFieldUri;
import io.deephaven.uri.RemoteProxiedUri;
import io.deephaven.uri.RemoteQueryScopeUri;
import io.deephaven.uri.StructuredUri;
import java.net.URI;
import java.util.Objects;
import org.immutables.value.Value;

@Value.Immutable
@SimpleStyle
public abstract class RemoteUri
extends DeephavenUriBase {
    public static RemoteUri of(DeephavenTarget target, StructuredUri uri) {
        return ImmutableRemoteUri.of(target, uri);
    }

    public static boolean isValidScheme(String scheme) {
        return DeephavenTarget.isValidScheme(scheme);
    }

    public static boolean isWellFormed(URI uri) {
        return RemoteApplicationUri.isWellFormed(uri) || RemoteFieldUri.isWellFormed(uri) || RemoteQueryScopeUri.isWellFormed(uri) || RemoteProxiedUri.isWellFormed(uri);
    }

    public static RemoteUri of(URI uri) {
        if (RemoteApplicationUri.isWellFormed(uri)) {
            return RemoteApplicationUri.of(uri);
        }
        if (RemoteFieldUri.isWellFormed(uri)) {
            return RemoteFieldUri.of(uri);
        }
        if (RemoteQueryScopeUri.isWellFormed(uri)) {
            return RemoteQueryScopeUri.of(uri);
        }
        if (RemoteProxiedUri.isWellFormed(uri)) {
            return RemoteProxiedUri.of(uri);
        }
        throw new IllegalArgumentException(String.format("Invalid remote Deephaven URI '%s'", uri));
    }

    @Value.Parameter
    public abstract DeephavenTarget target();

    @Value.Parameter
    public abstract StructuredUri uri();

    @Override
    public final <V extends StructuredUri.Visitor> V walk(V visitor) {
        visitor.visit(this);
        return visitor;
    }

    @Override
    public final String toString() {
        return this.uri().walk(new ToString()).out();
    }

    private class ToString
    implements StructuredUri.Visitor {
        private String out;

        private ToString() {
        }

        public String out() {
            return Objects.requireNonNull(this.out);
        }

        @Override
        public void visit(QueryScopeUri queryScopeUri) {
            this.out = RemoteQueryScopeUri.toString(RemoteUri.this.target(), queryScopeUri);
        }

        @Override
        public void visit(ApplicationUri applicationUri) {
            this.out = RemoteApplicationUri.toString(RemoteUri.this.target(), applicationUri);
        }

        @Override
        public void visit(FieldUri fieldUri) {
            this.out = RemoteFieldUri.toString(RemoteUri.this.target(), fieldUri);
        }

        @Override
        public void visit(RemoteUri remoteUri) {
            this.out = RemoteProxiedUri.toString(RemoteUri.this.target(), remoteUri);
        }

        @Override
        public void visit(URI customUri) {
            this.out = RemoteProxiedUri.toString(RemoteUri.this.target(), customUri);
        }
    }
}

