/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.channel;

import io.deephaven.base.RAPriQueue;
import io.deephaven.base.verify.Assert;
import io.deephaven.base.verify.Require;
import io.deephaven.hash.KeyedObjectHashMap;
import io.deephaven.hash.KeyedObjectKey;
import io.deephaven.util.annotations.FinalDefault;
import io.deephaven.util.channel.SeekableChannelContext;
import io.deephaven.util.channel.SeekableChannelsProvider;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedChannelProvider
implements SeekableChannelsProvider {
    private final SeekableChannelsProvider wrappedProvider;
    private final int maximumPooledCount;
    private long logicalClock;
    private long pooledCount;
    private final Map<ChannelType, KeyedObjectHashMap<String, PerPathPool>> channelPools;
    private final RAPriQueue<PerPathPool> releasePriority;

    public static CachedChannelProvider create(@NotNull SeekableChannelsProvider wrappedProvider, int maximumPooledCount) {
        if (wrappedProvider instanceof CachedChannelProvider) {
            throw new IllegalArgumentException("Cannot wrap a CachedChannelProvider in another CachedChannelProvider");
        }
        return new CachedChannelProvider(wrappedProvider, maximumPooledCount);
    }

    private CachedChannelProvider(@NotNull SeekableChannelsProvider wrappedProvider, int maximumPooledCount) {
        EnumMap channelPoolsTemp = new EnumMap(ChannelType.class);
        Arrays.stream(ChannelType.values()).forEach(ct -> channelPoolsTemp.put((ChannelType)((Object)ct), new KeyedObjectHashMap(PerPathPool.KOHM_KEY)));
        this.channelPools = Collections.unmodifiableMap(channelPoolsTemp);
        this.releasePriority = new RAPriQueue(8, PerPathPool.RAPQ_ADAPTER, PerPathPool.class);
        this.wrappedProvider = wrappedProvider;
        this.maximumPooledCount = Require.gtZero((int)maximumPooledCount, (String)"maximumPooledCount");
    }

    @Override
    public SeekableChannelContext makeContext() {
        return this.wrappedProvider.makeContext();
    }

    @Override
    public SeekableChannelContext makeSingleUseContext() {
        return this.wrappedProvider.makeSingleUseContext();
    }

    @Override
    public boolean isCompatibleWith(@NotNull SeekableChannelContext channelContext) {
        return this.wrappedProvider.isCompatibleWith(channelContext);
    }

    @Override
    public SeekableByteChannel getReadChannel(@NotNull SeekableChannelContext channelContext, @NotNull URI uri) throws IOException {
        KeyedObjectHashMap<String, PerPathPool> channelPool;
        String uriString = uri.toString();
        CachedChannel result = this.tryGetPooledChannel(uriString, channelPool = this.channelPools.get((Object)ChannelType.Read));
        CachedChannel channel = result == null ? new CachedChannel(this.wrappedProvider.getReadChannel(channelContext, uri), ChannelType.Read, uriString) : result.position(0L);
        channel.setContext(channelContext);
        return channel;
    }

    @Override
    public InputStream getInputStream(SeekableByteChannel channel, int sizeHint) throws IOException {
        return this.wrappedProvider.getInputStream(channel, sizeHint);
    }

    @Override
    public SeekableByteChannel getWriteChannel(@NotNull Path path, boolean append) throws IOException {
        ChannelType channelType;
        KeyedObjectHashMap<String, PerPathPool> channelPool;
        String pathKey = path.toAbsolutePath().toString();
        CachedChannel result = this.tryGetPooledChannel(pathKey, channelPool = this.channelPools.get((Object)(channelType = append ? ChannelType.WriteAppend : ChannelType.Write)));
        return result == null ? new CachedChannel(this.wrappedProvider.getWriteChannel(path, append), channelType, pathKey) : result.position(append ? result.size() : 0L);
    }

    @Override
    public Stream<URI> list(@NotNull URI directory) throws IOException {
        return this.wrappedProvider.list(directory);
    }

    @Override
    public Stream<URI> walk(@NotNull URI directory) throws IOException {
        return this.wrappedProvider.walk(directory);
    }

    @Nullable
    private synchronized CachedChannel tryGetPooledChannel(@NotNull String pathKey, @NotNull KeyedObjectHashMap<String, PerPathPool> channelPool) {
        CachedChannel result;
        PerPathPool perPathPool = (PerPathPool)channelPool.get((Object)pathKey);
        if (perPathPool == null || perPathPool.availableChannels.isEmpty()) {
            result = null;
        } else {
            result = perPathPool.availableChannels.removeFirst();
            Assert.eqFalse((boolean)result.isOpen, (String)"result.isOpen");
            result.isOpen = true;
            if (perPathPool.availableChannels.isEmpty()) {
                this.releasePriority.remove((Object)perPathPool);
            }
            --this.pooledCount;
        }
        return result;
    }

    private synchronized void returnPoolableChannel(@NotNull CachedChannel cachedChannel) throws IOException {
        Assert.eqFalse((boolean)cachedChannel.isOpen, (String)"cachedChannel.isOpen");
        cachedChannel.closeTime = this.advanceClock();
        if (this.pooledCount == (long)this.maximumPooledCount) {
            PerPathPool oldestClosedNonEmpty = (PerPathPool)this.releasePriority.removeTop();
            oldestClosedNonEmpty.availableChannels.removeLast().dispose();
            if (!oldestClosedNonEmpty.availableChannels.isEmpty()) {
                this.releasePriority.enter((Object)oldestClosedNonEmpty);
            }
        } else {
            ++this.pooledCount;
        }
        PerPathPool perPathPool = (PerPathPool)this.channelPools.get((Object)cachedChannel.channelType).putIfAbsent((Object)cachedChannel.pathKey, pk -> new PerPathPool(cachedChannel.channelType, cachedChannel.pathKey));
        perPathPool.availableChannels.addFirst(cachedChannel);
        this.releasePriority.enter((Object)perPathPool);
    }

    private long advanceClock() {
        Assert.holdsLock((Object)this, (String)"this");
        long newClock = ++this.logicalClock;
        if (newClock > 0L) {
            return newClock;
        }
        this.channelPools.values().forEach(Map::clear);
        this.releasePriority.clear();
        this.pooledCount = 0L;
        this.logicalClock = 1L;
        return 1L;
    }

    public void close() {
        this.wrappedProvider.close();
    }

    private static class PerPathPool {
        private static final RAPriQueue.Adapter<PerPathPool> RAPQ_ADAPTER = new RAPriQueue.Adapter<PerPathPool>(){

            public boolean less(@NotNull PerPathPool ppp1, @NotNull PerPathPool ppp2) {
                CachedChannel ch1 = ppp1.availableChannels.peekLast();
                CachedChannel ch2 = ppp2.availableChannels.peekLast();
                Assert.neq((long)Objects.requireNonNull(ch1).closeTime, (String)"ch1.closeTime", (long)Objects.requireNonNull(ch2).closeTime, (String)"ch2.closeTime");
                return ch1.closeTime < ch2.closeTime;
            }

            public void setPos(@NotNull PerPathPool ppp, int slot) {
                ppp.priorityQueueSlot = slot;
            }

            public int getPos(@NotNull PerPathPool ppp) {
                return ppp.priorityQueueSlot;
            }
        };
        private static final KeyedObjectKey<String, PerPathPool> KOHM_KEY = new KeyedObjectKey.Basic<String, PerPathPool>(){

            public String getKey(@NotNull PerPathPool ppp) {
                return ppp.path;
            }
        };
        private final ChannelType channelType;
        private final String path;
        private final Deque<CachedChannel> availableChannels = new ArrayDeque<CachedChannel>();
        private int priorityQueueSlot;

        private PerPathPool(@NotNull ChannelType channelType, @NotNull String path) {
            this.channelType = channelType;
            this.path = path;
        }
    }

    private class CachedChannel
    implements SeekableByteChannel,
    ContextHolder {
        private final SeekableByteChannel wrappedChannel;
        private final ChannelType channelType;
        private final String pathKey;
        private volatile boolean isOpen = true;
        private long closeTime;

        private CachedChannel(@NotNull SeekableByteChannel wrappedChannel, @NotNull ChannelType channelType, String pathKey) {
            this.wrappedChannel = wrappedChannel;
            this.channelType = channelType;
            this.pathKey = pathKey;
        }

        @Override
        public int read(@NotNull ByteBuffer dst) throws IOException {
            Require.eqTrue((boolean)this.isOpen, (String)"isOpen");
            return this.wrappedChannel.read(dst);
        }

        @Override
        public int write(@NotNull ByteBuffer src) throws IOException {
            Require.eqTrue((boolean)this.isOpen, (String)"isOpen");
            return this.wrappedChannel.write(src);
        }

        @Override
        public long position() throws IOException {
            Require.eqTrue((boolean)this.isOpen, (String)"isOpen");
            return this.wrappedChannel.position();
        }

        @Override
        public CachedChannel position(long newPosition) throws IOException {
            Require.eqTrue((boolean)this.isOpen, (String)"isOpen");
            this.wrappedChannel.position(newPosition);
            return this;
        }

        @Override
        public long size() throws IOException {
            Require.eqTrue((boolean)this.isOpen, (String)"isOpen");
            return this.wrappedChannel.size();
        }

        @Override
        public SeekableByteChannel truncate(long size) throws IOException {
            Require.eqTrue((boolean)this.isOpen, (String)"isOpen");
            this.wrappedChannel.truncate(size);
            return this;
        }

        public String toString() {
            return this.pathKey;
        }

        @Override
        public boolean isOpen() {
            return this.isOpen;
        }

        @Override
        public void close() throws IOException {
            Require.eqTrue((boolean)this.isOpen, (String)"isOpen");
            this.isOpen = false;
            this.clearContext();
            CachedChannelProvider.this.returnPoolableChannel(this);
        }

        private void dispose() throws IOException {
            this.wrappedChannel.close();
        }

        @Override
        public final void setContext(@Nullable SeekableChannelContext channelContext) {
            if (this.wrappedChannel instanceof ContextHolder) {
                ((ContextHolder)((Object)this.wrappedChannel)).setContext(channelContext);
            }
        }
    }

    static enum ChannelType {
        Read,
        Write,
        WriteAppend;

    }

    public static interface ContextHolder {
        public void setContext(SeekableChannelContext var1);

        @FinalDefault
        default public void clearContext() {
            this.setContext(null);
        }
    }
}

