/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.channel;

import com.google.common.io.CountingInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.Objects;

public final class ChannelPositionInputStream
extends FilterInputStream {
    private final SeekableByteChannel ch;
    private final long startingPosition;

    public static InputStream of(SeekableByteChannel channel, InputStream in) throws IOException {
        return new ChannelPositionInputStream(channel, in);
    }

    private ChannelPositionInputStream(SeekableByteChannel ch, InputStream in) throws IOException {
        super((InputStream)new CountingInputStream(in));
        this.ch = Objects.requireNonNull(ch);
        this.startingPosition = ch.position();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.ch.position(this.startingPosition + ((CountingInputStream)this.in).getCount());
    }
}

