/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.channel;

import io.deephaven.base.FileUtils;
import io.deephaven.util.channel.Channels;
import io.deephaven.util.channel.SeekableChannelContext;
import io.deephaven.util.channel.SeekableChannelsProvider;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalFSChannelProvider
implements SeekableChannelsProvider {
    private static final int MAX_READ_BUFFER_SIZE = 65536;

    @Override
    public SeekableChannelContext makeContext() {
        return SeekableChannelContext.NULL;
    }

    @Override
    public boolean isCompatibleWith(@Nullable SeekableChannelContext channelContext) {
        return true;
    }

    @Override
    public SeekableByteChannel getReadChannel(@Nullable SeekableChannelContext channelContext, @NotNull URI uri) throws IOException {
        return FileChannel.open(Path.of(uri), StandardOpenOption.READ);
    }

    @Override
    public InputStream getInputStream(SeekableByteChannel channel, int sizeHint) {
        int bufferSize = Math.min(sizeHint, 65536);
        return new BufferedInputStream(Channels.newInputStreamNoClose(channel), bufferSize);
    }

    @Override
    public SeekableByteChannel getWriteChannel(@NotNull Path filePath, boolean append) throws IOException {
        FileChannel result = FileChannel.open(filePath, StandardOpenOption.WRITE, StandardOpenOption.CREATE, append ? StandardOpenOption.APPEND : StandardOpenOption.TRUNCATE_EXISTING);
        if (append) {
            result.position(result.size());
        } else {
            result.position(0L);
        }
        return result;
    }

    @Override
    public final Stream<URI> list(@NotNull URI directory) throws IOException {
        return Files.list(Path.of(directory)).map(path -> FileUtils.convertToURI((Path)path, (boolean)false));
    }

    @Override
    public final Stream<URI> walk(@NotNull URI directory) throws IOException {
        return Files.walk(Path.of(directory), new FileVisitOption[0]).map(path -> FileUtils.convertToURI((Path)path, (boolean)false));
    }

    public void close() {
    }
}

