/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.channel;

import io.deephaven.base.FileUtils;
import io.deephaven.util.SafeCloseable;
import io.deephaven.util.channel.ChannelPositionInputStream;
import io.deephaven.util.channel.SeekableChannelContext;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public interface SeekableChannelsProvider
extends SafeCloseable {
    public static InputStream channelPositionInputStream(SeekableChannelsProvider provider, SeekableByteChannel ch, int sizeHint) throws IOException {
        return ChannelPositionInputStream.of(ch, provider.getInputStream(ch, sizeHint));
    }

    public SeekableChannelContext makeContext();

    default public SeekableChannelContext makeSingleUseContext() {
        return this.makeContext();
    }

    public boolean isCompatibleWith(@NotNull SeekableChannelContext var1);

    default public SeekableByteChannel getReadChannel(@NotNull SeekableChannelContext channelContext, @NotNull String uriStr) throws IOException {
        return this.getReadChannel(channelContext, FileUtils.convertToURI((String)uriStr, (boolean)false));
    }

    public SeekableByteChannel getReadChannel(@NotNull SeekableChannelContext var1, @NotNull URI var2) throws IOException;

    public InputStream getInputStream(SeekableByteChannel var1, int var2) throws IOException;

    default public SeekableByteChannel getWriteChannel(@NotNull String path, boolean append) throws IOException {
        return this.getWriteChannel(Paths.get(path, new String[0]), append);
    }

    public SeekableByteChannel getWriteChannel(@NotNull Path var1, boolean var2) throws IOException;

    public Stream<URI> list(@NotNull URI var1) throws IOException;

    public Stream<URI> walk(@NotNull URI var1) throws IOException;
}

