/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.util.channel;

import io.deephaven.util.channel.SeekableChannelsProvider;
import io.deephaven.util.channel.SeekableChannelsProviderPlugin;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SeekableChannelsProviderLoader {
    private static volatile SeekableChannelsProviderLoader instance;
    private final List<SeekableChannelsProviderPlugin> providers = new ArrayList<SeekableChannelsProviderPlugin>();

    public static SeekableChannelsProviderLoader getInstance() {
        if (instance == null) {
            instance = new SeekableChannelsProviderLoader();
        }
        return instance;
    }

    private SeekableChannelsProviderLoader() {
        for (SeekableChannelsProviderPlugin plugin : ServiceLoader.load(SeekableChannelsProviderPlugin.class)) {
            this.providers.add(plugin);
        }
    }

    public SeekableChannelsProvider fromServiceLoader(@NotNull URI uri, @Nullable Object specialInstructions) {
        for (SeekableChannelsProviderPlugin plugin : this.providers) {
            if (!plugin.isCompatible(uri, specialInstructions)) continue;
            return plugin.createProvider(uri, specialInstructions);
        }
        throw new UnsupportedOperationException("No plugin found for uri: " + uri);
    }
}

