/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.function;

import io.deephaven.function.ToBooleanFunction;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

class BooleanFunctions {
    BooleanFunctions() {
    }

    static <T> ToBooleanFunction<T> cast() {
        return BooleanFunctions.cast(PrimitiveBoolean.INSTANCE);
    }

    static <T> ToBooleanFunction<T> cast(ToBooleanFunction<? super T> f) {
        return f;
    }

    static <T> ToBooleanFunction<T> of(Predicate<? super T> predicate) {
        return predicate instanceof ToBooleanFunction ? BooleanFunctions.cast((ToBooleanFunction)predicate) : predicate::test;
    }

    public static <T> ToBooleanFunction<T> ofTrue() {
        return OfTrue.INSTANCE;
    }

    public static <T> ToBooleanFunction<T> ofFalse() {
        return OfFalse.INSTANCE;
    }

    static <T, R> ToBooleanFunction<T> map(Function<? super T, ? extends R> f, Predicate<? super R> g) {
        return new BooleanMap<T, R>(f, g);
    }

    static <T> ToBooleanFunction<T> not(Predicate<? super T> f) {
        return f instanceof BooleanNot ? BooleanFunctions.cast(((BooleanNot)f).negate()) : new BooleanNot<T>(f);
    }

    static <T> ToBooleanFunction<T> or(Collection<Predicate<? super T>> functions) {
        if (functions.isEmpty()) {
            return BooleanFunctions.ofFalse();
        }
        if (functions.size() == 1) {
            return BooleanFunctions.of(functions.iterator().next());
        }
        return new BooleanOr<T>(functions);
    }

    static <T> ToBooleanFunction<T> and(Collection<Predicate<? super T>> functions) {
        if (functions.isEmpty()) {
            return BooleanFunctions.ofTrue();
        }
        if (functions.size() == 1) {
            return BooleanFunctions.of(functions.iterator().next());
        }
        return new BooleanAnd<T>(functions);
    }

    private static class BooleanOr<T>
    implements ToBooleanFunction<T> {
        private final Collection<Predicate<? super T>> functions;

        public BooleanOr(Collection<Predicate<? super T>> functions) {
            this.functions = List.copyOf(functions);
        }

        @Override
        public boolean test(T value) {
            for (Predicate<T> function : this.functions) {
                if (!function.test(value)) continue;
                return true;
            }
            return false;
        }

        @Override
        @NotNull
        public ToBooleanFunction<T> negate() {
            return new BooleanAnd(this.functions.stream().map(Predicate::negate).collect(Collectors.toList()));
        }

        @Override
        @NotNull
        public ToBooleanFunction<T> or(@NotNull Predicate<? super T> other) {
            return new BooleanOr<T>(Stream.concat(this.functions.stream(), Stream.of(other)).collect(Collectors.toList()));
        }
    }

    private static class BooleanAnd<T>
    implements ToBooleanFunction<T> {
        private final Collection<Predicate<? super T>> functions;

        public BooleanAnd(Collection<Predicate<? super T>> functions) {
            this.functions = List.copyOf(functions);
        }

        @Override
        public boolean test(T value) {
            for (Predicate<T> function : this.functions) {
                if (function.test(value)) continue;
                return false;
            }
            return true;
        }

        @Override
        @NotNull
        public ToBooleanFunction<T> negate() {
            return new BooleanOr(this.functions.stream().map(Predicate::negate).collect(Collectors.toList()));
        }

        @Override
        @NotNull
        public ToBooleanFunction<T> and(@NotNull Predicate<? super T> other) {
            return new BooleanAnd<T>(Stream.concat(this.functions.stream(), Stream.of(other)).collect(Collectors.toList()));
        }
    }

    private static class BooleanNot<T>
    implements ToBooleanFunction<T> {
        private final Predicate<? super T> function;

        public BooleanNot(Predicate<? super T> function) {
            this.function = Objects.requireNonNull(function);
        }

        @Override
        public boolean test(T value) {
            return !this.function.test(value);
        }

        @Override
        @NotNull
        public ToBooleanFunction<T> negate() {
            return BooleanFunctions.of(this.function);
        }
    }

    private static class BooleanMap<T, R>
    implements ToBooleanFunction<T> {
        private final Function<? super T, ? extends R> f;
        private final Predicate<? super R> g;

        public BooleanMap(Function<? super T, ? extends R> f, Predicate<? super R> g) {
            this.f = Objects.requireNonNull(f);
            this.g = Objects.requireNonNull(g);
        }

        @Override
        public boolean test(T value) {
            return this.g.test(this.f.apply(value));
        }

        @Override
        @NotNull
        public ToBooleanFunction<T> negate() {
            return new BooleanMap<T, R>(this.f, this.g.negate());
        }
    }

    private static enum PrimitiveBoolean implements ToBooleanFunction<Object>
    {
        INSTANCE;


        @Override
        public boolean test(Object value) {
            return (Boolean)value;
        }
    }

    private static enum OfFalse implements ToBooleanFunction<Object>
    {
        INSTANCE;


        @Override
        public boolean test(Object value) {
            return false;
        }

        @Override
        @NotNull
        public ToBooleanFunction<Object> negate() {
            return BooleanFunctions.ofTrue();
        }

        @Override
        @NotNull
        public ToBooleanFunction<Object> and(@NotNull Predicate<? super Object> other) {
            return this;
        }

        @Override
        @NotNull
        public ToBooleanFunction<Object> or(@NotNull Predicate<? super Object> other) {
            return BooleanFunctions.of(other);
        }
    }

    private static enum OfTrue implements ToBooleanFunction<Object>
    {
        INSTANCE;


        @Override
        public boolean test(Object value) {
            return true;
        }

        @Override
        @NotNull
        public ToBooleanFunction<Object> negate() {
            return BooleanFunctions.ofFalse();
        }

        @Override
        @NotNull
        public ToBooleanFunction<Object> and(@NotNull Predicate<? super Object> other) {
            return BooleanFunctions.of(other);
        }

        @Override
        @NotNull
        public ToBooleanFunction<Object> or(@NotNull Predicate<? super Object> other) {
            return this;
        }
    }
}

