/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.function;

import io.deephaven.function.ToByteFunction;
import java.util.Objects;
import java.util.function.Function;

class ByteFunctions {
    ByteFunctions() {
    }

    static <T> ToByteFunction<T> cast() {
        return ByteFunctions.cast(PrimitiveByte.INSTANCE);
    }

    static <T> ToByteFunction<T> cast(ToByteFunction<? super T> f) {
        return f;
    }

    static <T, R> ToByteFunction<T> map(Function<? super T, ? extends R> f, ToByteFunction<? super R> g) {
        return new ByteMap<T, R>(f, g);
    }

    private static class ByteMap<T, R>
    implements ToByteFunction<T> {
        private final Function<? super T, ? extends R> f;
        private final ToByteFunction<? super R> g;

        public ByteMap(Function<? super T, ? extends R> f, ToByteFunction<? super R> g) {
            this.f = Objects.requireNonNull(f);
            this.g = Objects.requireNonNull(g);
        }

        @Override
        public byte applyAsByte(T value) {
            return this.g.applyAsByte(this.f.apply(value));
        }
    }

    private static enum PrimitiveByte implements ToByteFunction<Object>
    {
        INSTANCE;


        @Override
        public byte applyAsByte(Object value) {
            return (Byte)value;
        }
    }
}

