/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.function;

import io.deephaven.function.ToCharFunction;
import java.util.Objects;
import java.util.function.Function;

class CharFunctions {
    CharFunctions() {
    }

    static <T> ToCharFunction<T> cast() {
        return CharFunctions.cast(PrimitiveChar.INSTANCE);
    }

    static <T> ToCharFunction<T> cast(ToCharFunction<? super T> f) {
        return f;
    }

    static <T, R> ToCharFunction<T> map(Function<? super T, ? extends R> f, ToCharFunction<? super R> g) {
        return new CharMap<T, R>(f, g);
    }

    private static class CharMap<T, R>
    implements ToCharFunction<T> {
        private final Function<? super T, ? extends R> f;
        private final ToCharFunction<? super R> g;

        public CharMap(Function<? super T, ? extends R> f, ToCharFunction<? super R> g) {
            this.f = Objects.requireNonNull(f);
            this.g = Objects.requireNonNull(g);
        }

        @Override
        public char applyAsChar(T value) {
            return this.g.applyAsChar(this.f.apply(value));
        }
    }

    private static enum PrimitiveChar implements ToCharFunction<Object>
    {
        INSTANCE;


        @Override
        public char applyAsChar(Object value) {
            return ((Character)value).charValue();
        }
    }
}

