/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.function;

import io.deephaven.function.ToDoubleFunction;
import java.util.Objects;
import java.util.function.Function;

class DoubleFunctions {
    DoubleFunctions() {
    }

    static <T> ToDoubleFunction<T> cast() {
        return DoubleFunctions.cast(PrimitiveDouble.INSTANCE);
    }

    static <T> ToDoubleFunction<T> cast(ToDoubleFunction<? super T> f) {
        return f;
    }

    static <T> ToDoubleFunction<T> of(java.util.function.ToDoubleFunction<? super T> f) {
        return f instanceof ToDoubleFunction ? DoubleFunctions.cast((ToDoubleFunction)f) : f::applyAsDouble;
    }

    static <T, R> ToDoubleFunction<T> map(Function<? super T, ? extends R> f, java.util.function.ToDoubleFunction<? super R> g) {
        return new DoubleFunctionMap<T, R>(f, g);
    }

    private static class DoubleFunctionMap<T, R>
    implements ToDoubleFunction<T> {
        private final Function<? super T, ? extends R> f;
        private final java.util.function.ToDoubleFunction<? super R> g;

        public DoubleFunctionMap(Function<? super T, ? extends R> f, java.util.function.ToDoubleFunction<? super R> g) {
            this.f = Objects.requireNonNull(f);
            this.g = Objects.requireNonNull(g);
        }

        @Override
        public double applyAsDouble(T value) {
            return this.g.applyAsDouble(this.f.apply(value));
        }
    }

    private static enum PrimitiveDouble implements ToDoubleFunction<Object>
    {
        INSTANCE;


        @Override
        public double applyAsDouble(Object value) {
            return (Double)value;
        }
    }
}

