/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.function;

import io.deephaven.function.ToFloatFunction;
import java.util.Objects;
import java.util.function.Function;

class FloatFunctions {
    FloatFunctions() {
    }

    static <T> ToFloatFunction<T> cast() {
        return FloatFunctions.cast(PrimitiveFloat.INSTANCE);
    }

    static <T> ToFloatFunction<T> cast(ToFloatFunction<? super T> f) {
        return f;
    }

    static <T, R> ToFloatFunction<T> map(Function<? super T, ? extends R> f, ToFloatFunction<? super R> g) {
        return new FloatMap<T, R>(f, g);
    }

    private static class FloatMap<T, R>
    implements ToFloatFunction<T> {
        private final Function<? super T, ? extends R> f;
        private final ToFloatFunction<? super R> g;

        public FloatMap(Function<? super T, ? extends R> f, ToFloatFunction<? super R> g) {
            this.f = Objects.requireNonNull(f);
            this.g = Objects.requireNonNull(g);
        }

        @Override
        public float applyAsFloat(T value) {
            return this.g.applyAsFloat(this.f.apply(value));
        }
    }

    private static enum PrimitiveFloat implements ToFloatFunction<Object>
    {
        INSTANCE;


        @Override
        public float applyAsFloat(Object value) {
            return ((Float)value).floatValue();
        }
    }
}

