/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.function;

import io.deephaven.function.ToIntFunction;
import java.util.Objects;
import java.util.function.Function;

class IntFunctions {
    IntFunctions() {
    }

    static <T> ToIntFunction<T> cast() {
        return IntFunctions.cast(PrimitiveInt.INSTANCE);
    }

    static <T> ToIntFunction<T> cast(ToIntFunction<? super T> f) {
        return f;
    }

    static <T> ToIntFunction<T> of(java.util.function.ToIntFunction<? super T> f) {
        return f instanceof ToIntFunction ? IntFunctions.cast((ToIntFunction)f) : f::applyAsInt;
    }

    static <T, R> ToIntFunction<T> map(Function<? super T, ? extends R> f, java.util.function.ToIntFunction<? super R> g) {
        return new IntMap<T, R>(f, g);
    }

    private static class IntMap<T, R>
    implements ToIntFunction<T> {
        private final Function<? super T, ? extends R> f;
        private final java.util.function.ToIntFunction<? super R> g;

        public IntMap(Function<? super T, ? extends R> f, java.util.function.ToIntFunction<? super R> g) {
            this.f = Objects.requireNonNull(f);
            this.g = Objects.requireNonNull(g);
        }

        @Override
        public int applyAsInt(T value) {
            return this.g.applyAsInt(this.f.apply(value));
        }
    }

    private static enum PrimitiveInt implements ToIntFunction<Object>
    {
        INSTANCE;


        @Override
        public int applyAsInt(Object value) {
            return (Integer)value;
        }
    }
}

