/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.function;

import io.deephaven.function.ToBooleanFunction;
import io.deephaven.function.ToByteFunction;
import io.deephaven.function.ToCharFunction;
import io.deephaven.function.ToDoubleFunction;
import io.deephaven.function.ToFloatFunction;
import io.deephaven.function.ToIntFunction;
import io.deephaven.function.ToLongFunction;
import io.deephaven.function.ToObjectFunction;
import io.deephaven.function.ToPrimitiveFunction;
import io.deephaven.function.ToShortFunction;
import java.util.Objects;

class PrimitiveFunctions {
    PrimitiveFunctions() {
    }

    static <T> ToPrimitiveFunction<T> cast(ToPrimitiveFunction<? super T> f) {
        return f;
    }

    static <T, R> ToPrimitiveFunction<T> map(ToObjectFunction<? super T, ? extends R> f, ToPrimitiveFunction<? super R> g) {
        return MapPrimitiveVisitor.of(f, g);
    }

    private static class MapPrimitiveVisitor<T, R>
    implements ToPrimitiveFunction.Visitor<T, ToPrimitiveFunction<R>> {
        private final ToObjectFunction<? super R, ? extends T> f;

        public static <T, R> ToPrimitiveFunction<R> of(ToObjectFunction<? super R, ? extends T> f, ToPrimitiveFunction<? super T> g) {
            return (ToPrimitiveFunction)g.walk(new MapPrimitiveVisitor<T, R>(f));
        }

        private MapPrimitiveVisitor(ToObjectFunction<? super R, ? extends T> f) {
            this.f = Objects.requireNonNull(f);
        }

        @Override
        public ToBooleanFunction<R> visit(ToBooleanFunction<T> g) {
            return this.f.mapToBoolean(g);
        }

        @Override
        public ToCharFunction<R> visit(ToCharFunction<T> g) {
            return this.f.mapToChar(g);
        }

        @Override
        public ToByteFunction<R> visit(ToByteFunction<T> g) {
            return this.f.mapToByte(g);
        }

        @Override
        public ToShortFunction<R> visit(ToShortFunction<T> g) {
            return this.f.mapToShort(g);
        }

        @Override
        public ToIntFunction<R> visit(ToIntFunction<T> g) {
            return this.f.mapToInt(g);
        }

        @Override
        public ToLongFunction<R> visit(ToLongFunction<T> g) {
            return this.f.mapToLong(g);
        }

        @Override
        public ToFloatFunction<R> visit(ToFloatFunction<T> g) {
            return this.f.mapToFloat(g);
        }

        @Override
        public ToDoubleFunction<R> visit(ToDoubleFunction<T> g) {
            return this.f.mapToDouble(g);
        }
    }
}

