/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.function;

import io.deephaven.function.ToShortFunction;
import java.util.Objects;
import java.util.function.Function;

class ShortFunctions {
    ShortFunctions() {
    }

    static <T> ToShortFunction<T> cast() {
        return ShortFunctions.cast(PrimitiveShort.INSTANCE);
    }

    static <T> ToShortFunction<T> cast(ToShortFunction<? super T> f) {
        return f;
    }

    static <T, R> ToShortFunction<T> map(Function<? super T, ? extends R> f, ToShortFunction<? super R> g) {
        return new ShortMap<T, R>(f, g);
    }

    private static class ShortMap<T, R>
    implements ToShortFunction<T> {
        private final Function<? super T, ? extends R> f;
        private final ToShortFunction<? super R> g;

        public ShortMap(Function<? super T, ? extends R> f, ToShortFunction<? super R> g) {
            this.f = Objects.requireNonNull(f);
            this.g = Objects.requireNonNull(g);
        }

        @Override
        public short applyAsShort(T value) {
            return this.g.applyAsShort(this.f.apply(value));
        }
    }

    private static enum PrimitiveShort implements ToShortFunction<Object>
    {
        INSTANCE;


        @Override
        public short applyAsShort(Object value) {
            return (Short)value;
        }
    }
}

