/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.function;

import io.deephaven.function.BooleanFunctions;
import io.deephaven.function.ToPrimitiveFunction;
import io.deephaven.qst.type.BooleanType;
import io.deephaven.qst.type.Type;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface ToBooleanFunction<T>
extends ToPrimitiveFunction<T>,
Predicate<T> {
    public static <T> ToBooleanFunction<T> cast() {
        return BooleanFunctions.cast();
    }

    public static <T> ToBooleanFunction<T> ofTrue() {
        return BooleanFunctions.ofTrue();
    }

    public static <T> ToBooleanFunction<T> ofFalse() {
        return BooleanFunctions.ofFalse();
    }

    public static <T, R> ToBooleanFunction<T> map(Function<? super T, ? extends R> f, Predicate<? super R> g) {
        return BooleanFunctions.map(f, g);
    }

    public static <T> ToBooleanFunction<T> or(Collection<Predicate<? super T>> functions) {
        return BooleanFunctions.or(functions);
    }

    public static <T> ToBooleanFunction<T> and(Collection<Predicate<? super T>> functions) {
        return BooleanFunctions.and(functions);
    }

    public static <T> ToBooleanFunction<T> not(Predicate<? super T> f) {
        return BooleanFunctions.not(f);
    }

    @Override
    public boolean test(T var1);

    default public BooleanType returnType() {
        return Type.booleanType();
    }

    @Override
    default public <R> R walk(ToPrimitiveFunction.Visitor<T, R> visitor) {
        return visitor.visit(this);
    }

    @Override
    @NotNull
    default public ToBooleanFunction<T> negate() {
        return ToBooleanFunction.not(this);
    }

    @Override
    @NotNull
    default public ToBooleanFunction<T> and(@NotNull Predicate<? super T> other) {
        return ToBooleanFunction.and(List.of(this, other));
    }

    @Override
    @NotNull
    default public ToBooleanFunction<T> or(@NotNull Predicate<? super T> other) {
        return ToBooleanFunction.or(List.of(this, other));
    }
}

