/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.function;

import io.deephaven.function.ObjectFunctions;
import io.deephaven.function.PrimitiveFunctions;
import io.deephaven.function.ToBooleanFunction;
import io.deephaven.function.ToByteFunction;
import io.deephaven.function.ToCharFunction;
import io.deephaven.function.ToDoubleFunction;
import io.deephaven.function.ToFloatFunction;
import io.deephaven.function.ToIntFunction;
import io.deephaven.function.ToLongFunction;
import io.deephaven.function.ToPrimitiveFunction;
import io.deephaven.function.ToShortFunction;
import io.deephaven.function.TypedFunction;
import io.deephaven.function.TypedFunctions;
import io.deephaven.qst.type.GenericType;
import java.util.function.Function;
import java.util.function.Predicate;

public interface ToObjectFunction<T, R>
extends TypedFunction<T>,
Function<T, R> {
    public static <T, R> ToObjectFunction<T, R> of(Function<? super T, ? extends R> f, GenericType<R> returnType) {
        return ObjectFunctions.of(f, returnType);
    }

    public static <T> ToObjectFunction<T, Object> identity() {
        return ObjectFunctions.identity();
    }

    public static <T, R extends T> ToObjectFunction<T, R> identity(GenericType<R> returnType) {
        return ObjectFunctions.identity().cast(returnType);
    }

    public static <T, R, Z> ToObjectFunction<T, Z> map(Function<? super T, ? extends R> f, ToObjectFunction<? super R, Z> g) {
        return ObjectFunctions.map(f, g);
    }

    public static <T, R, Z> ToObjectFunction<T, Z> map(Function<? super T, ? extends R> f, Function<? super R, ? extends Z> g, GenericType<Z> returnType) {
        return ObjectFunctions.map(f, g, returnType);
    }

    @Override
    public GenericType<R> returnType();

    @Override
    public R apply(T var1);

    default public <T2 extends T> ToBooleanFunction<T2> mapToBoolean(Predicate<? super R> g) {
        return ToBooleanFunction.map(this, g);
    }

    default public <T2 extends T> ToCharFunction<T2> mapToChar(ToCharFunction<? super R> g) {
        return ToCharFunction.map(this, g);
    }

    default public <T2 extends T> ToByteFunction<T2> mapToByte(ToByteFunction<? super R> g) {
        return ToByteFunction.map(this, g);
    }

    default public <T2 extends T> ToShortFunction<T2> mapToShort(ToShortFunction<? super R> g) {
        return ToShortFunction.map(this, g);
    }

    default public <T2 extends T> ToIntFunction<T2> mapToInt(java.util.function.ToIntFunction<? super R> g) {
        return ToIntFunction.map(this, g);
    }

    default public <T2 extends T> ToLongFunction<T2> mapToLong(java.util.function.ToLongFunction<? super R> g) {
        return ToLongFunction.map(this, g);
    }

    default public <T2 extends T> ToFloatFunction<T2> mapToFloat(ToFloatFunction<? super R> g) {
        return ToFloatFunction.map(this, g);
    }

    default public <T2 extends T> ToDoubleFunction<T2> mapToDouble(java.util.function.ToDoubleFunction<? super R> g) {
        return ToDoubleFunction.map(this, g);
    }

    default public <T2 extends T, R2> ToObjectFunction<T2, R2> mapToObj(ToObjectFunction<? super R, R2> g) {
        return ToObjectFunction.map(this, g);
    }

    default public <T2 extends T, R2> ToObjectFunction<T2, R2> mapToObj(Function<? super R, ? extends R2> g, GenericType<R2> returnType) {
        return ToObjectFunction.map(this, g, returnType);
    }

    default public <T2 extends T> ToPrimitiveFunction<T2> mapToPrimitive(ToPrimitiveFunction<? super R> g) {
        return PrimitiveFunctions.map(this, g);
    }

    default public <T2 extends T> TypedFunction<T2> map(TypedFunction<? super R> g) {
        return TypedFunctions.map(this, g);
    }

    default public <T2 extends T, R2> ToObjectFunction<T2, R2> cast(GenericType<R2> returnType) {
        return ObjectFunctions.castOrMapCast(this, returnType);
    }

    @Override
    default public <Z> Z walk(TypedFunction.Visitor<T, Z> visitor) {
        return visitor.visit(this);
    }
}

