/*
 * Decompiled with CFR 0.152.
 */
package io.deephaven.function;

import io.deephaven.function.ToObjectFunction;
import io.deephaven.function.ToPrimitiveFunction;
import io.deephaven.function.TypedFunction;
import java.util.Objects;

class TypedFunctions {
    TypedFunctions() {
    }

    static <T> TypedFunction<T> cast(TypedFunction<? super T> f) {
        return f;
    }

    static <T, R> TypedFunction<T> map(ToObjectFunction<? super T, ? extends R> f, TypedFunction<? super R> g) {
        return MapVisitor.of(f, g);
    }

    private static class MapVisitor<T, R>
    implements TypedFunction.Visitor<T, TypedFunction<R>> {
        private final ToObjectFunction<? super R, ? extends T> f;

        public static <T, R> TypedFunction<R> of(ToObjectFunction<? super R, ? extends T> f, TypedFunction<? super T> g) {
            return (TypedFunction)g.walk(new MapVisitor<T, R>(f));
        }

        private MapVisitor(ToObjectFunction<? super R, ? extends T> f) {
            this.f = Objects.requireNonNull(f);
        }

        @Override
        public ToPrimitiveFunction<R> visit(ToPrimitiveFunction<T> g) {
            return this.f.mapToPrimitive(g);
        }

        @Override
        public ToObjectFunction<R, ?> visit(ToObjectFunction<T, ?> g) {
            return this.f.mapToObj(g);
        }
    }
}

