/*
 * Decompiled with CFR 0.152.
 */
package io.deepmedia.tools.publisher.sonatype;

import com.android.build.gradle.internal.tasks.factory.TaskFactoryUtils;
import io.deepmedia.tools.publisher.Handler;
import io.deepmedia.tools.publisher.UtilsKt;
import io.deepmedia.tools.publisher.common.Scm;
import io.deepmedia.tools.publisher.sonatype.SonatypeAuth;
import io.deepmedia.tools.publisher.sonatype.SonatypeHandler;
import io.deepmedia.tools.publisher.sonatype.SonatypePublication;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.artifacts.repositories.MavenArtifactRepository;
import org.gradle.api.artifacts.repositories.PasswordCredentials;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.tasks.TaskProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0016J\u0010\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u001c\u0010\u0006\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/deepmedia/tools/publisher/sonatype/SonatypeHandler;", "Lio/deepmedia/tools/publisher/Handler;", "Lio/deepmedia/tools/publisher/sonatype/SonatypePublication;", "target", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "allTask", "Lorg/gradle/api/tasks/TaskProvider;", "Lorg/gradle/api/Task;", "kotlin.jvm.PlatformType", "checkPublication", "", "publication", "fatal", "", "createPublication", "name", "", "createPublicationTask", "mavenPublication", "Lorg/gradle/api/publish/maven/MavenPublication;", "fillPublication", "ownsPublication", "Companion", "publisher"})
public final class SonatypeHandler
extends Handler<SonatypePublication> {
    private final TaskProvider<Task> allTask;
    @NotNull
    public static final String PREFIX = "sonatype";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean ownsPublication(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return StringsKt.startsWith$default((String)name, (String)PREFIX, (boolean)false, (int)2, null);
    }

    @Override
    @NotNull
    public SonatypePublication createPublication(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return new SonatypePublication(name);
    }

    @Override
    public void fillPublication(@NotNull SonatypePublication publication) {
        Intrinsics.checkParameterIsNotNull((Object)publication, (String)"publication");
        io.deepmedia.tools.publisher.common.Project project = publication.getProject();
        String string = publication.getProject().getDescription();
        if (string == null) {
            string = publication.getProject().getName();
        }
        project.setDescription(string);
        SonatypeAuth sonatypeAuth = publication.getAuth();
        Project project2 = this.getTarget();
        String string2 = publication.getAuth().getUser();
        if (string2 == null) {
            string2 = "auth.user";
        }
        sonatypeAuth.setUser(UtilsKt.findSecret(project2, string2));
        SonatypeAuth sonatypeAuth2 = publication.getAuth();
        Project project3 = this.getTarget();
        String string3 = publication.getAuth().getPassword();
        if (string3 == null) {
            string3 = "auth.password";
        }
        sonatypeAuth2.setPassword(UtilsKt.findSecret(project3, string3));
    }

    @Override
    public void checkPublication(@NotNull SonatypePublication publication, boolean fatal) {
        Intrinsics.checkParameterIsNotNull((Object)publication, (String)"publication");
        UtilsKt.checkPublicationField$default(this.getTarget(), fatal, publication.getAuth().getUser(), "sonatype.auth.user", null, 8, null);
        UtilsKt.checkPublicationField$default(this.getTarget(), fatal, publication.getAuth().getPassword(), "sonatype.auth.password", null, 8, null);
        UtilsKt.checkPublicationField$default(this.getTarget(), fatal, publication.getSigning().getKey(), "signing.key", null, 8, null);
        UtilsKt.checkPublicationField$default(this.getTarget(), fatal, publication.getSigning().getPassword(), "signing.password", null, 8, null);
        UtilsKt.checkPublicationField(this.getTarget(), fatal, publication.getRelease().getSources(), "release.sources", (Function0<String>)((Function0)checkPublication.1.INSTANCE));
        UtilsKt.checkPublicationField(this.getTarget(), fatal, publication.getRelease().getDocs(), "release.docs", (Function0<String>)((Function0)checkPublication.2.INSTANCE));
        UtilsKt.checkPublicationField(this.getTarget(), fatal, publication.getProject().getUrl(), "project.url", (Function0<String>)((Function0)checkPublication.3.INSTANCE));
        Collection collection = publication.getProject().getLicenses();
        boolean bl = false;
        UtilsKt.checkPublicationFieldCondition(this.getTarget(), fatal, !collection.isEmpty(), "project.licenses", (Function0<String>)((Function0)checkPublication.4.INSTANCE));
        collection = publication.getProject().getDevelopers();
        bl = false;
        UtilsKt.checkPublicationFieldCondition(this.getTarget(), fatal, !collection.isEmpty(), "project.developers", (Function0<String>)((Function0)checkPublication.5.INSTANCE));
        Scm scm = publication.getProject().getScm();
        UtilsKt.checkPublicationField(this.getTarget(), fatal, scm != null ? scm.getConnection() : null, "project.scm.connection", (Function0<String>)((Function0)checkPublication.6.INSTANCE));
        Scm scm2 = publication.getProject().getScm();
        UtilsKt.checkPublicationField(this.getTarget(), fatal, scm2 != null ? scm2.getDeveloperConnection() : null, "project.scm.developerConnection", (Function0<String>)((Function0)checkPublication.7.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String createPublicationTask(@NotNull SonatypePublication publication, @NotNull MavenPublication mavenPublication) {
        void $this$getByType$iv;
        Intrinsics.checkParameterIsNotNull((Object)publication, (String)"publication");
        Intrinsics.checkParameterIsNotNull((Object)mavenPublication, (String)"mavenPublication");
        String repository = publication.getName();
        ExtensionContainer extensionContainer = this.getTarget().getExtensions();
        Intrinsics.checkExpressionValueIsNotNull((Object)extensionContainer, (String)"target.extensions");
        Object object = extensionContainer;
        Class<PublishingExtension> type$iv = PublishingExtension.class;
        boolean $i$f$getByType = false;
        Object object2 = $this$getByType$iv.getByType(type$iv);
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"`getByType`(`type`.java)");
        PublishingExtension publishing = (PublishingExtension)object2;
        publishing.repositories((Action)new Action<RepositoryHandler>(repository, publication){
            final /* synthetic */ String $repository;
            final /* synthetic */ SonatypePublication $publication;

            public final void execute(@NotNull RepositoryHandler $this$repositories) {
                Intrinsics.checkParameterIsNotNull((Object)$this$repositories, (String)"$receiver");
                $this$repositories.maven((Action)new Action<MavenArtifactRepository>(this){
                    final /* synthetic */ createPublicationTask.1 this$0;

                    public final void execute(@NotNull MavenArtifactRepository $this$maven) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$maven, (String)"$receiver");
                        $this$maven.setName(this.this$0.$repository);
                        $this$maven.setUrl((Object)this.this$0.$publication.getRepository());
                        PasswordCredentials passwordCredentials = $this$maven.getCredentials();
                        Intrinsics.checkExpressionValueIsNotNull((Object)passwordCredentials, (String)"credentials");
                        passwordCredentials.setPassword(this.this$0.$publication.getAuth().getPassword());
                        PasswordCredentials passwordCredentials2 = $this$maven.getCredentials();
                        Intrinsics.checkExpressionValueIsNotNull((Object)passwordCredentials2, (String)"credentials");
                        passwordCredentials2.setUsername(this.this$0.$publication.getAuth().getUser());
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$repository = string;
                this.$publication = sonatypePublication;
            }
        });
        StringBuilder stringBuilder = new StringBuilder().append("publish");
        String string = mavenPublication.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"mavenPublication.name");
        object = stringBuilder.append(StringsKt.capitalize((String)string)).append("PublicationTo").append(StringsKt.capitalize((String)repository)).append("Repository").toString();
        boolean bl = false;
        boolean bl2 = false;
        Object it = object;
        boolean bl3 = false;
        TaskFactoryUtils.dependsOn(this.allTask, (String)it);
        return object;
    }

    public SonatypeHandler(@NotNull Project target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        super(target);
        TaskProvider taskProvider = target.getTasks().register("publishAll" + StringsKt.capitalize((String)PREFIX));
        Intrinsics.checkExpressionValueIsNotNull((Object)taskProvider, (String)"target.tasks.register(\"p\u2026l${PREFIX.capitalize()}\")");
        this.allTask = taskProvider;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/deepmedia/tools/publisher/sonatype/SonatypeHandler$Companion;", "", "()V", "PREFIX", "", "publisher"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

