/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.csv;

import java.io.PrintWriter;
import org.apache.spark.sql.execution.datasources.csv.CSVOptions;
import org.apache.spark.sql.execution.datasources.csv.LineCsvWriter;
import org.apache.spark.sql.types.StructType;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001U4A!\u0001\u0002\u0001#\t!Bj\\2bY\u000e\u001bhoT;uaV$xK]5uKJT!a\u0001\u0003\u0002\u0007\r\u001chO\u0003\u0002\u0006\r\u0005YA-\u0019;bg>,(oY3t\u0015\t9\u0001\"A\u0005fq\u0016\u001cW\u000f^5p]*\u0011\u0011BC\u0001\u0004gFd'BA\u0006\r\u0003\u0015\u0019\b/\u0019:l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0005\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\t\u0011e\u0001!\u0011!Q\u0001\ni\t!\u0002Z1uCN\u001b\u0007.Z7b!\tYb$D\u0001\u001d\u0015\ti\u0002\"A\u0003usB,7/\u0003\u0002 9\tQ1\u000b\u001e:vGR$\u0016\u0010]3\t\u0011\u0005\u0002!\u0011!Q\u0001\n\t\na\u0001]1sC6\u001c\bCA\u0012%\u001b\u0005\u0011\u0011BA\u0013\u0003\u0005)\u00195KV(qi&|gn\u001d\u0005\tO\u0001\u0011\t\u0011)A\u0005Q\u0005QAM]5wKJ\u0004\u0016\r\u001e5\u0011\u0005%bcBA\n+\u0013\tYC#\u0001\u0004Qe\u0016$WMZ\u0005\u0003[9\u0012aa\u0015;sS:<'BA\u0016\u0015\u0011\u0015\u0001\u0004\u0001\"\u00012\u0003\u0019a\u0014N\\5u}Q!!g\r\u001b6!\t\u0019\u0003\u0001C\u0003\u001a_\u0001\u0007!\u0004C\u0003\"_\u0001\u0007!\u0005C\u0003(_\u0001\u0007\u0001\u0006C\u00048\u0001\t\u0007I\u0011\u0002\u001d\u0002!\u0011\u0014\u0018N^3s\r&dWm\u0016:ji\u0016\u0014X#A\u001d\u0011\u0005izT\"A\u001e\u000b\u0005qj\u0014AA5p\u0015\u0005q\u0014\u0001\u00026bm\u0006L!\u0001Q\u001e\u0003\u0017A\u0013\u0018N\u001c;Xe&$XM\u001d\u0005\u0007\u0005\u0002\u0001\u000b\u0011B\u001d\u0002#\u0011\u0014\u0018N^3s\r&dWm\u0016:ji\u0016\u0014\b\u0005C\u0004E\u0001\t\u0007I\u0011B#\u0002!\u0019cUk\u0015%`\u0005\u0006#6\tS0T\u0013j+U#\u0001$\u0011\u0005M9\u0015B\u0001%\u0015\u0005\u0011auN\\4\t\r)\u0003\u0001\u0015!\u0003G\u0003E1E*V*I?\n\u000bEk\u0011%`'&SV\t\t\u0005\b\u0019\u0002\u0001\r\u0011\"\u0003F\u0003\u001d\u0011XmY8sINDqA\u0014\u0001A\u0002\u0013%q*A\u0006sK\u000e|'\u000fZ:`I\u0015\fHC\u0001)T!\t\u0019\u0012+\u0003\u0002S)\t!QK\\5u\u0011\u001d!V*!AA\u0002\u0019\u000b1\u0001\u001f\u00132\u0011\u00191\u0006\u0001)Q\u0005\r\u0006A!/Z2pe\u0012\u001c\b\u0005C\u0004Y\u0001\t\u0007I\u0011B-\u0002\u0013\r\u001cho\u0016:ji\u0016\u0014X#\u0001.\u0011\u0005\rZ\u0016B\u0001/\u0003\u00055a\u0015N\\3DgZ<&/\u001b;fe\"1a\f\u0001Q\u0001\ni\u000b!bY:w/JLG/\u001a:!\u0011\u0015\u0001\u0007\u0001\"\u0001b\u0003\u00159(/\u001b;f)\t\u0001&\rC\u0003d?\u0002\u0007A-A\u0002s_^\u00042!Z7)\u001d\t17N\u0004\u0002hU6\t\u0001N\u0003\u0002j!\u00051AH]8pizJ\u0011!F\u0005\u0003YR\tq\u0001]1dW\u0006<W-\u0003\u0002o_\n\u00191+Z9\u000b\u00051$\u0002\"B9\u0001\t\u0013\u0011\u0018!\u00024mkNDG#\u0001)\t\u000bQ\u0004A\u0011\u0001:\u0002\u000b\rdwn]3")
public class LocalCsvOutputWriter {
    private final CSVOptions params;
    private final PrintWriter driverFileWriter;
    private final long FLUSH_BATCH_SIZE;
    private long records;
    private final LineCsvWriter csvWriter;

    private PrintWriter driverFileWriter() {
        return this.driverFileWriter;
    }

    private long FLUSH_BATCH_SIZE() {
        return this.FLUSH_BATCH_SIZE;
    }

    private long records() {
        return this.records;
    }

    private void records_$eq(long x$1) {
        this.records = x$1;
    }

    private LineCsvWriter csvWriter() {
        return this.csvWriter;
    }

    public void write(Seq<String> row) {
        this.csvWriter().writeRow(row, this.records() == 0L && this.params.headerFlag());
        this.records_$eq(this.records() + 1L);
        if (this.records() % this.FLUSH_BATCH_SIZE() == 0L) {
            this.flush();
        }
    }

    private void flush() {
        String lines = this.csvWriter().flush();
        if (new StringOps(Predef$.MODULE$.augmentString(lines)).nonEmpty()) {
            this.driverFileWriter().write(lines);
        }
    }

    public void close() {
        this.flush();
        this.driverFileWriter().close();
    }

    public LocalCsvOutputWriter(StructType dataSchema, CSVOptions params, String driverPath) {
        this.params = params;
        this.driverFileWriter = new PrintWriter(driverPath);
        this.FLUSH_BATCH_SIZE = 1024L;
        this.records = 0L;
        this.csvWriter = new LineCsvWriter(params, Predef$.MODULE$.refArrayOps((Object[])dataSchema.fieldNames()).toSeq());
    }
}

