/*
 * Decompiled with CFR 0.152.
 */
package defaultj.annotations.processor;

import defaultj.annotations.Default;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

public class DefaultAnnotationValidator
extends AbstractProcessor {
    private static final String DEFAULT = Default.class.getSimpleName();
    private static final EnumSet<ElementKind> FIELDS_OR_METHODS = EnumSet.of(ElementKind.FIELD, ElementKind.METHOD);
    private Messager messager;
    private boolean hasError;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        this.messager = processingEnv.getMessager();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> annotations = new LinkedHashSet<String>();
        annotations.add(Default.class.getCanonicalName());
        return annotations;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    private void error(Element e, String msg) {
        this.hasError = true;
        this.messager.printMessage(Diagnostic.Kind.ERROR, msg, e);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.hasError = false;
        for (Element element : roundEnv.getElementsAnnotatedWith(Default.class)) {
            if (FIELDS_OR_METHODS.contains((Object)element.getKind())) {
                this.ensureModifier(element, Modifier.PUBLIC);
                this.ensureModifier(element, Modifier.STATIC);
                this.ensureModifier(element, Modifier.FINAL);
                continue;
            }
            if (ElementKind.CONSTRUCTOR.equals((Object)element.getKind())) {
                this.ensureModifier(element, Modifier.PUBLIC);
                continue;
            }
            if (element.getKind().equals((Object)ElementKind.ENUM_CONSTANT)) continue;
            this.error(element, String.format("Only constructors, enum constants, fields or methods can be annotated with @%s!", DEFAULT));
        }
        return this.hasError;
    }

    private void ensureModifier(Element element, Modifier modifier) {
        if (element.getModifiers().contains((Object)modifier)) {
            return;
        }
        this.error(element, String.format("Only %s element can be annotated with @%s!", new Object[]{modifier, DEFAULT}));
    }
}

