/*
 * Decompiled with CFR 0.152.
 */
package defaultj.annotations.processor;

import defaultj.annotations.DefaultInterface;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;

public class DefaultInterfaceAnnotationValidator
extends AbstractProcessor {
    private static final String DEFAULT_INTERFACE = DefaultInterface.class.getSimpleName();
    private Messager messager;
    private boolean hasError;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        this.messager = processingEnv.getMessager();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        LinkedHashSet<String> annotations = new LinkedHashSet<String>();
        annotations.add(DefaultInterface.class.getCanonicalName());
        return annotations;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    private void error(Element e, String msg) {
        this.hasError = true;
        this.messager.printMessage(Diagnostic.Kind.ERROR, msg, e);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.hasError = false;
        for (Element element : roundEnv.getElementsAnnotatedWith(DefaultInterface.class)) {
            if (ElementKind.INTERFACE.equals((Object)element.getKind())) {
                new InterfaceChecker(element).ensureDefaultInterface();
                continue;
            }
            this.error(element, String.format("Only interfaces can be annotated with @%s!", DEFAULT_INTERFACE));
        }
        return this.hasError;
    }

    private class InterfaceChecker {
        private Element orgInterface;
        private final Map<String, String> abstracts = new TreeMap<String, String>();
        private final Set<String> defaults = new TreeSet<String>();

        private void ensureDefaultInterface() {
            this.ensureDefaultInterface(this.orgInterface);
            this.defaults.forEach(m -> this.abstracts.remove(m));
            this.abstracts.forEach((mthd, clzz) -> DefaultInterfaceAnnotationValidator.this.error(this.orgInterface, String.format("Interface %s is annotated with @%s but has a non-default method: %s (%s)!", this.orgInterface, DEFAULT_INTERFACE, mthd, clzz)));
        }

        private void ensureDefaultInterface(Element element) {
            for (Element element2 : element.getEnclosedElements()) {
                if (element2.getModifiers().contains((Object)Modifier.DEFAULT)) {
                    this.defaults.add(element2.toString().replaceAll(" default ", " "));
                    continue;
                }
                this.abstracts.put(element2.toString().replaceAll(" abstract ", " "), element.toString());
            }
            for (TypeMirror typeMirror : ((TypeElement)element).getInterfaces()) {
                Element interfaceElement = ((DeclaredType)typeMirror).asElement();
                this.ensureDefaultInterface(interfaceElement);
            }
        }

        public InterfaceChecker(Element orgInterface) {
            this.orgInterface = orgInterface;
        }
    }
}

