/*
 * Decompiled with CFR 0.152.
 */
package defaultj.api;

import defaultj.api.BasicDefaultProvider;
import defaultj.api.IProvideDefault;
import defaultj.api.RequiredDefaultProviderNotAvailableException;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

class utils {
    static final AtomicReference<Optional<IProvideDefault>> cachedProvider = new AtomicReference<Object>(null);

    utils() {
    }

    static Class<?> findClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    static IProvideDefault loadDefaultByName(String className) throws Exception {
        boolean isClassInClasspath;
        Class<?> providerClass = utils.findClass(className);
        boolean bl = isClassInClasspath = providerClass != null;
        if (!isClassInClasspath) {
            throw new ClassNotFoundException(className);
        }
        boolean isCompatibleType = IProvideDefault.class.isAssignableFrom(providerClass);
        if (!isCompatibleType) {
            throw new ClassCastException(className);
        }
        Object newInstance = providerClass.newInstance();
        IProvideDefault provider = (IProvideDefault)IProvideDefault.class.cast(newInstance);
        return provider;
    }

    static Optional<IProvideDefault> loadDefault() {
        String requireClassName = System.getProperty("DefaultProviderClassName");
        if (requireClassName != null && !requireClassName.trim().isEmpty()) {
            try {
                IProvideDefault requireProvider = utils.loadDefaultByName(requireClassName);
                return Optional.of(requireProvider);
            }
            catch (Exception e) {
                System.err.println("Required DefaultProvider does not exist or fail to load: " + requireClassName);
                e.printStackTrace();
                throw new RequiredDefaultProviderNotAvailableException(e);
            }
        }
        String suggestClassName = System.getProperty("SuggestDefaultProviderClassName");
        if (suggestClassName != null && !suggestClassName.trim().isEmpty()) {
            try {
                IProvideDefault suggestProvider = utils.loadDefaultByName(suggestClassName);
                return Optional.of(suggestProvider);
            }
            catch (Exception e) {
                System.err.println("Suggest DefaultProvider does not exist or fail to load: " + suggestClassName);
                e.printStackTrace();
            }
        }
        try {
            String className = "defaultj.core.DefaultProvider";
            IProvideDefault provider = utils.loadDefaultByName(className);
            return Optional.ofNullable(provider);
        }
        catch (Exception e) {
            String fallbackToBasicDefaultProvider = System.getProperty("FallbackToBasicDefaultProvider");
            if ("false".equalsIgnoreCase(fallbackToBasicDefaultProvider)) {
                return Optional.empty();
            }
            BasicDefaultProvider basicProvider = new BasicDefaultProvider();
            return Optional.of(basicProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Optional<IProvideDefault> getDefault() {
        if (cachedProvider.get() != null) {
            return cachedProvider.get();
        }
        Class<utils> clazz = utils.class;
        synchronized (utils.class) {
            if (cachedProvider.get() != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return cachedProvider.get();
            }
            Optional<IProvideDefault> loaded = utils.loadDefault();
            cachedProvider.compareAndSet(null, loaded);
            // ** MonitorExit[var0] (shouldn't be in output)
            return cachedProvider.get();
        }
    }
}

