/*
 * Decompiled with CFR 0.152.
 */
package defaultj.core.strategies;

import defaultj.annotations.DefaultInterface;
import defaultj.api.IProvideDefault;
import defaultj.core.exception.NonDefaultInterfaceException;
import defaultj.core.strategies.IFindSupplier;
import defaultj.core.utils.AnnotationUtils;
import defaultj.core.utils.failable.Failable;
import java.util.Map;
import nullablej.utils.reflection.UProxy;

public class DefaultInterfaceSupplierFinder
implements IFindSupplier {
    private static final String DEFAULT_INTERFACE = DefaultInterface.class.getSimpleName();

    @Override
    public <TYPE, THROWABLE extends Throwable> Failable.Supplier<TYPE, THROWABLE> find(Class<TYPE> theGivenClass, IProvideDefault defaultProvider) {
        boolean isDefaultInterface;
        boolean bl = isDefaultInterface = theGivenClass.isInterface() && AnnotationUtils.has(theGivenClass.getAnnotations(), DEFAULT_INTERFACE);
        if (!isDefaultInterface) {
            return null;
        }
        Map nonDefaults = UProxy.getNonDefaultMethods(theGivenClass);
        if (!nonDefaults.isEmpty()) {
            throw new NonDefaultInterfaceException(theGivenClass, nonDefaults);
        }
        Object theProxy = UProxy.createDefaultProxy(theGivenClass, (Class[])new Class[0]);
        return () -> theProxy;
    }
}

