/*
 * Decompiled with CFR 0.152.
 */
package defaultj.core.strategies;

import defaultj.annotations.ImplementedBy;
import defaultj.api.IProvideDefault;
import defaultj.core.exception.ImplementedClassNotCompatibleExistException;
import defaultj.core.exception.ImplementedClassNotExistException;
import defaultj.core.strategies.IFindSupplier;
import defaultj.core.strategies.common;
import defaultj.core.utils.AnnotationUtils;
import defaultj.core.utils.failable.Failable;
import defaultj.core.utils.failable.Failables;
import java.util.function.Function;
import nullablej.NullableJ;

public class ImplementedBySupplierFinder
implements IFindSupplier {
    private static final String ANNOTATION_NAME = ImplementedBy.class.getSimpleName();
    private static final Function<String, String> extractValue = toString -> toString.replaceAll("^(.*\\(value=class )(.*)(\\))$", "$2");
    private static final Function<Object, String> toString = Object::toString;

    @Override
    public <TYPE, THROWABLE extends Throwable> Failable.Supplier<TYPE, THROWABLE> find(Class<TYPE> theGivenClass, IProvideDefault defaultProvider) {
        if (!AnnotationUtils.has(theGivenClass.getAnnotations(), ANNOTATION_NAME)) {
            return null;
        }
        Class defaultImplementationClass = ImplementedBySupplierFinder.findDefaultImplementation(theGivenClass);
        if (NullableJ._isNull(defaultImplementationClass)) {
            return common.NullSupplier;
        }
        return Failables.of(() -> defaultProvider.get(defaultImplementationClass));
    }

    private static <T> Class<T> findDefaultImplementation(Class<T> theGivenClass) {
        Class<T> implementedClass = NullableJ._stream$((Object[])theGivenClass.getAnnotations()).map(toString).map(extractValue).map(ImplementedBySupplierFinder.findClass(theGivenClass)).findAny().get();
        if (!theGivenClass.isAssignableFrom(implementedClass)) {
            throw new ImplementedClassNotCompatibleExistException(theGivenClass, implementedClass.getName());
        }
        return implementedClass;
    }

    private static <T> Function<String, Class<T>> findClass(Class<?> theGivenClass) {
        return name -> {
            try {
                return Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                throw new ImplementedClassNotExistException(theGivenClass, (String)name, (Throwable)e);
            }
        };
    }
}

