/*
 * Decompiled with CFR 0.152.
 */
package defaultj.core.strategies;

import defaultj.annotations.Default;
import defaultj.api.IProvideDefault;
import defaultj.core.strategies.IFindSupplier;
import defaultj.core.utils.FieldUtils;
import defaultj.core.utils.failable.Failable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import nullablej.nullable.Nullable;

public class SingletonFieldFinder
implements IFindSupplier {
    private static final String DEFAULT = Default.class.getSimpleName();
    private static final Predicate<Field> annotatedWithDefault = FieldUtils.annotatedWith(DEFAULT);
    private static final Predicate<Object> notNull = Objects::nonNull;

    @Override
    public <TYPE, THROWABLE extends Throwable> Failable.Supplier<TYPE, THROWABLE> find(Class<TYPE> theGivenClass, IProvideDefault defaultProvider) {
        Failable.Supplier fieldValue = SingletonFieldFinder.findValueFromSingletonField(theGivenClass);
        return fieldValue;
    }

    private static <T> Failable.Supplier findValueFromSingletonField(Class<T> theGivenClass) {
        Helper<T> helper = new Helper<T>(theGivenClass);
        return Arrays.stream(theGivenClass.getDeclaredFields()).filter(FieldUtils.ifPublicField).filter(FieldUtils.ifStaticField).filter(annotatedWithDefault).map(helper::findValue).filter(notNull).findAny().orElse(null);
    }

    static final class Helper<T> {
        private final Class<T> theGivenClass;

        Failable.Supplier findValue(Field field) {
            Class<?> type = field.getType();
            if (this.theGivenClass.isAssignableFrom(type)) {
                return () -> this.getFieldValue(field);
            }
            Failable.Supplier optionalSupplier = this.findOptionalOrNullableFieldValue(field, type);
            if (optionalSupplier != null) {
                return optionalSupplier;
            }
            Failable.Supplier supplierSupplier = this.findSupplierFieldValue(field, type);
            if (supplierSupplier != null) {
                return supplierSupplier;
            }
            return null;
        }

        private Failable.Supplier findSupplierFieldValue(Field field, Class<?> type) {
            if (!Supplier.class.isAssignableFrom(type)) {
                return null;
            }
            ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
            Class actualType = (Class)parameterizedType.getActualTypeArguments()[0];
            if (!this.theGivenClass.isAssignableFrom(actualType)) {
                return null;
            }
            Failable.Supplier supplier = () -> {
                Object value = ((Supplier)this.getFieldValue(field)).get();
                return value;
            };
            return supplier;
        }

        private Object getFieldValue(Field field) throws IllegalAccessException {
            return field.get(this.theGivenClass);
        }

        private Failable.Supplier findOptionalOrNullableFieldValue(Field field, Class<?> type) {
            boolean isNullable;
            boolean isOptional = Optional.class.isAssignableFrom(type);
            boolean bl = isNullable = !isOptional && Nullable.class.isAssignableFrom(type);
            if (!isOptional && !isNullable) {
                return null;
            }
            ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
            Class actualType = (Class)parameterizedType.getActualTypeArguments()[0];
            if (!this.theGivenClass.isAssignableFrom(actualType)) {
                return null;
            }
            Failable.Supplier supplier = () -> {
                Object optional = this.getFieldValue(field);
                Object value = isOptional ? ((Optional)optional).orElse(null) : ((Nullable)optional).orElse(null);
                return value;
            };
            return supplier;
        }

        public Helper(Class<T> theGivenClass) {
            this.theGivenClass = theGivenClass;
        }

        public Class<T> getTheGivenClass() {
            return this.theGivenClass;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Helper)) {
                return false;
            }
            Helper other = (Helper)o;
            Class<T> this$theGivenClass = this.getTheGivenClass();
            Class<T> other$theGivenClass = other.getTheGivenClass();
            return !(this$theGivenClass == null ? other$theGivenClass != null : !this$theGivenClass.equals(other$theGivenClass));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<T> $theGivenClass = this.getTheGivenClass();
            result = result * 59 + ($theGivenClass == null ? 43 : $theGivenClass.hashCode());
            return result;
        }

        public String toString() {
            return "SingletonFieldFinder.Helper(theGivenClass=" + this.getTheGivenClass() + ")";
        }
    }
}

