/*
 * Decompiled with CFR 0.152.
 */
package defaultj.core;

import defaultj.core.IBind;
import defaultj.core.bindings.InstanceBinding;
import defaultj.core.bindings.TypeBinding;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Bindings {
    private final Map<Class, IBind> bindings;

    public Bindings(Map<Class, IBind> bindings) {
        this.bindings = Collections.unmodifiableMap(new HashMap<Class, IBind>(bindings));
    }

    public <TYPE> IBind<TYPE> getBinding(Class<TYPE> clzz) {
        return this.bindings.get(clzz);
    }

    public static class Builder {
        private final Map<Class, IBind> bindings = new HashMap<Class, IBind>();

        public Builder() {
        }

        public Builder(Bindings bindings) {
            if (bindings != null) {
                this.bindings.putAll(bindings.bindings);
            }
        }

        public <TYPE> Builder bind(Class<TYPE> clzz, IBind<? extends TYPE> binding) {
            if (binding != null) {
                this.bindings.put(clzz, binding);
            }
            return this;
        }

        public <TYPE> Builder bind(Class<TYPE> clzz, TYPE instance) {
            InstanceBinding<TYPE> instanceBinding = new InstanceBinding<TYPE>(instance);
            this.bindings.put(clzz, instanceBinding);
            return this;
        }

        public <TYPE> Builder bind(Class<TYPE> clzz, Class<? extends TYPE> boundClzz) {
            TypeBinding<? extends TYPE> typeBinding = new TypeBinding<TYPE>(boundClzz);
            this.bindings.put(clzz, typeBinding);
            return this;
        }

        public Builder bind(Bindings bindings) {
            if (bindings != null) {
                this.bindings.putAll(bindings.bindings);
            }
            return this;
        }

        public Bindings build() {
            return new Bindings(this.bindings);
        }
    }
}

