/*
 * Decompiled with CFR 0.152.
 */
package defaultj.core.strategies;

import defaultj.annotations.Default;
import defaultj.annotations.PostConstruct;
import defaultj.api.IProvideDefault;
import defaultj.core.strategies.IFindSupplier;
import defaultj.core.utils.ConstructorUtils;
import defaultj.core.utils.MethodSupplierFinderUtils;
import defaultj.core.utils.failable.Failable;
import defaultj.core.utils.failable.Failables;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import nullablej.NullableJ;

public class ConstructorSupplierFinder
implements IFindSupplier {
    private static final String ANNOTATION_NAME = Default.class.getSimpleName();

    @Override
    public <TYPE, THROWABLE extends Throwable> Failable.Supplier<TYPE, THROWABLE> find(Class<TYPE> theGivenClass, IProvideDefault defaultProvider) {
        Constructor constructor = (Constructor)NullableJ._orGet(ConstructorUtils.findConstructorWithAnnotation(theGivenClass, ANNOTATION_NAME), ConstructorUtils.sensibleDefaultConstructorOf(theGivenClass));
        if (!ConstructorUtils._isPublic(constructor)) {
            return null;
        }
        Failable.Supplier supplier = Failables.of(() -> this.callConstructor(constructor, defaultProvider));
        return supplier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <TYPE> TYPE callConstructor(Constructor<TYPE> constructor, IProvideDefault defaultProvider) throws ReflectiveOperationException {
        Method[] methods;
        Object[] paramValues = MethodSupplierFinderUtils.prepareParameters(constructor, defaultProvider);
        TYPE instance = constructor.newInstance(paramValues);
        for (Method method : methods = instance.getClass().getDeclaredMethods()) {
            for (Annotation annotation : method.getAnnotations()) {
                String annotationName = annotation.annotationType().getSimpleName();
                boolean isPostContruct = PostConstruct.class.getSimpleName().equals(annotationName);
                if (!isPostContruct) continue;
                boolean isAccessible = method.isAccessible();
                try {
                    method.setAccessible(true);
                    method.invoke(instance, new Object[0]);
                }
                finally {
                    method.setAccessible(isAccessible);
                }
            }
        }
        return instance;
    }
}

