/*
 * Decompiled with CFR 0.152.
 */
package defaultj.core.strategies;

import defaultj.annotations.DefaultImplementation;
import defaultj.api.IProvideDefault;
import defaultj.core.strategies.IFindSupplier;
import defaultj.core.strategies.common;
import defaultj.core.utils.AnnotationUtils;
import defaultj.core.utils.failable.Failable;
import defaultj.core.utils.failable.Failables;
import java.lang.annotation.Annotation;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class DefaultImplementationSupplierFinder
implements IFindSupplier {
    private static final String ANNOTATION_NAME = DefaultImplementation.class.getSimpleName();
    public static final Predicate<? super Annotation> isDefaultImplementation = annotation -> {
        Class<? extends Annotation> annotationType = annotation.annotationType();
        String simpleName = annotationType.getSimpleName();
        return ANNOTATION_NAME.equals(simpleName);
    };

    @Override
    public <TYPE, THROWABLE extends Throwable> Failable.Supplier<TYPE, THROWABLE> find(Class<TYPE> theGivenClass, IProvideDefault defaultProvider) {
        if (!AnnotationUtils.has(theGivenClass.getAnnotations(), ANNOTATION_NAME)) {
            return null;
        }
        Class defaultImplementationClass = DefaultImplementationSupplierFinder.findDefaultImplementation(theGivenClass);
        if (defaultImplementationClass == null) {
            return null;
        }
        return Failables.of(() -> defaultProvider.get(defaultImplementationClass));
    }

    private static <T> Class<T> findDefaultImplementation(Class<T> theGivenClass) {
        Class implementedClass = Stream.of(theGivenClass.getAnnotations()).filter(isDefaultImplementation).map(common.toString).map(common.extractValue).map(DefaultImplementationSupplierFinder.findClass()).filter(common.notNull).filter(DefaultImplementationSupplierFinder.isAssignableTo(theGivenClass)).findAny().orElse(null);
        return implementedClass;
    }

    private static <T> Function<String, Class<T>> findClass() {
        return name -> {
            try {
                return Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        };
    }

    private static <T> Predicate<Class<T>> isAssignableTo(Class<?> theGivenClass) {
        return theGivenClass::isAssignableFrom;
    }
}

