/*
 * Decompiled with CFR 0.152.
 */
package defaultj.core.strategies;

import defaultj.annotations.Default;
import defaultj.api.IProvideDefault;
import defaultj.core.exception.DefaultCreationException;
import defaultj.core.strategies.IFindSupplier;
import defaultj.core.utils.AnnotationUtils;
import defaultj.core.utils.failable.Failable;
import java.util.function.Predicate;
import nullablej.NullableJ;

public class EnumValueSupplierFinder
implements IFindSupplier {
    private static final String DEFAULT = Default.class.getSimpleName();

    @Override
    public <TYPE, THROWABLE extends Throwable> Failable.Supplier<TYPE, THROWABLE> find(Class<TYPE> theGivenClass, IProvideDefault defaultProvider) {
        if (!theGivenClass.isEnum()) {
            return null;
        }
        Object enumValue = EnumValueSupplierFinder.findDefaultEnumValue(theGivenClass);
        return () -> enumValue;
    }

    private static <T> T findDefaultEnumValue(Class<T> theGivenClass) {
        Object[] enumConstants = theGivenClass.getEnumConstants();
        if (NullableJ._isEmpty((Object[])enumConstants)) {
            return null;
        }
        Object enumConstant = NullableJ._find((Object[])enumConstants, EnumValueSupplierFinder.defaultEnumValue(theGivenClass)).orElse(enumConstants[0]);
        return (T)enumConstant;
    }

    static <T> Predicate<T> defaultEnumValue(Class<T> theGivenClass) {
        return value -> {
            String name = ((Enum)value).name();
            try {
                return AnnotationUtils.has(theGivenClass.getField(name).getAnnotations(), DEFAULT);
            }
            catch (NoSuchFieldException | SecurityException e) {
                throw new DefaultCreationException(theGivenClass, e);
            }
        };
    }
}

