/*
 * Decompiled with CFR 0.152.
 */
package defaultj.core.strategies;

import defaultj.annotations.ImplementedBy;
import defaultj.api.IProvideDefault;
import defaultj.core.exception.ImplementedClassNotCompatibleExistException;
import defaultj.core.exception.ImplementedClassNotExistException;
import defaultj.core.strategies.IFindSupplier;
import defaultj.core.strategies.common;
import defaultj.core.utils.AnnotationUtils;
import defaultj.core.utils.failable.Failable;
import defaultj.core.utils.failable.Failables;
import java.util.function.Function;
import java.util.stream.Stream;
import nullablej.NullableJ;

public class ImplementedBySupplierFinder
implements IFindSupplier {
    public static final String ANNOTATION_NAME = ImplementedBy.class.getSimpleName();

    @Override
    public <TYPE, THROWABLE extends Throwable> Failable.Supplier<TYPE, THROWABLE> find(Class<TYPE> theGivenClass, IProvideDefault defaultProvider) {
        if (!AnnotationUtils.has(theGivenClass.getAnnotations(), ANNOTATION_NAME)) {
            return null;
        }
        Class defaultImplementationClass = ImplementedBySupplierFinder.findDefaultImplementation(theGivenClass);
        if (NullableJ._isNull(defaultImplementationClass)) {
            return common.NullSupplier;
        }
        return Failables.of(() -> defaultProvider.get(defaultImplementationClass));
    }

    private static <T> Class<T> findDefaultImplementation(Class<T> theGivenClass) {
        Class implementedClass = Stream.of(theGivenClass.getAnnotations()).filter(annotation -> ANNOTATION_NAME.equals(annotation.annotationType().getSimpleName())).map(common.toString).map(common.extractValue).map(ImplementedBySupplierFinder.findClass(theGivenClass)).findAny().orElse(null);
        if (!theGivenClass.isAssignableFrom(implementedClass)) {
            throw new ImplementedClassNotCompatibleExistException(theGivenClass, implementedClass.getName());
        }
        return implementedClass;
    }

    private static <T> Function<String, Class<T>> findClass(Class<?> theGivenClass) {
        return name -> {
            try {
                return Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                throw new ImplementedClassNotExistException(theGivenClass, (String)name, (Throwable)e);
            }
        };
    }
}

