/*
 * Decompiled with CFR 0.152.
 */
package defaultj.core.strategies;

import defaultj.annotations.Default;
import defaultj.api.IProvideDefault;
import defaultj.core.strategies.IFindSupplier;
import defaultj.core.utils.FieldUtils;
import defaultj.core.utils.failable.Failable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import nullablej.nullable.Nullable;

public class SingletonFieldFinder
implements IFindSupplier {
    private static final String DEFAULT = Default.class.getSimpleName();
    private static final Predicate<Field> annotatedWithDefault = FieldUtils.annotatedWith(DEFAULT);
    private static final Predicate<Object> notNull = Objects::nonNull;

    @Override
    public <TYPE, THROWABLE extends Throwable> Failable.Supplier<TYPE, THROWABLE> find(Class<TYPE> theGivenClass, IProvideDefault defaultProvider) {
        Failable.Supplier fieldValue = SingletonFieldFinder.findValueFromSingletonField(theGivenClass);
        return fieldValue;
    }

    private static <T> Failable.Supplier findValueFromSingletonField(Class<T> theGivenClass) {
        Helper<T> helper = new Helper<T>(theGivenClass);
        return Arrays.stream(theGivenClass.getDeclaredFields()).filter(FieldUtils.ifPublicField).filter(FieldUtils.ifStaticField).filter(FieldUtils.ifFinalField).filter(annotatedWithDefault).map(helper::findValue).filter(notNull).findAny().orElse(null);
    }

    static class Helper<T> {
        private Class<T> theGivenClass;

        public Helper(Class<T> theGivenClass) {
            this.theGivenClass = theGivenClass;
        }

        Failable.Supplier findValue(Field field) {
            Class<?> type = field.getType();
            if (this.theGivenClass.isAssignableFrom(type)) {
                return () -> this.getFieldValue(field);
            }
            Failable.Supplier optionalSupplier = this.findOptionalOrNullableFieldValue(field, type);
            if (optionalSupplier != null) {
                return optionalSupplier;
            }
            Failable.Supplier supplierSupplier = this.findSupplierFieldValue(field, type);
            if (supplierSupplier != null) {
                return supplierSupplier;
            }
            return null;
        }

        private Failable.Supplier findSupplierFieldValue(Field field, Class<?> type) {
            if (!Supplier.class.isAssignableFrom(type)) {
                return null;
            }
            ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
            Class actualType = (Class)parameterizedType.getActualTypeArguments()[0];
            if (!this.theGivenClass.isAssignableFrom(actualType)) {
                return null;
            }
            Failable.Supplier supplier = () -> {
                Object value = ((Supplier)this.getFieldValue(field)).get();
                return value;
            };
            return supplier;
        }

        private Object getFieldValue(Field field) throws IllegalAccessException {
            return field.get(this.theGivenClass);
        }

        private Failable.Supplier findOptionalOrNullableFieldValue(Field field, Class<?> type) {
            boolean isNullable;
            boolean isOptional = Optional.class.isAssignableFrom(type);
            boolean bl = isNullable = !isOptional && Nullable.class.isAssignableFrom(type);
            if (!isOptional && !isNullable) {
                return null;
            }
            ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
            Class actualType = (Class)parameterizedType.getActualTypeArguments()[0];
            if (!this.theGivenClass.isAssignableFrom(actualType)) {
                return null;
            }
            Failable.Supplier supplier = () -> {
                Object optional = this.getFieldValue(field);
                Object value = isOptional ? ((Optional)optional).orElse(null) : ((Nullable)optional).orElse(null);
                return value;
            };
            return supplier;
        }
    }
}

