/*
 * Decompiled with CFR 0.152.
 */
package defaultj.core.utils;

import java.lang.annotation.Annotation;
import java.util.function.Predicate;
import java.util.stream.Stream;
import nullablej.NullableJ;

public class AnnotationUtils {
    public static Predicate<? super Annotation> withNamed(String name) {
        return annotation -> {
            String toString = annotation.toString();
            return toString.matches("^@.*(\\.|\\$)" + name + "\\(.*$");
        };
    }

    public static boolean has(Annotation[] annotations, String ... names) {
        return Stream.of(names).anyMatch(name -> NullableJ._hasSome((Object[])annotations, AnnotationUtils.withNamed(name)));
    }

    public static boolean hasAllOf(Annotation[] annotations, String ... names) {
        return Stream.of(names).allMatch(name -> NullableJ._hasAll((Object[])annotations, AnnotationUtils.withNamed(name)));
    }
}

