/*
 * Decompiled with CFR 0.152.
 */
package defaultj.core.utils;

import defaultj.core.utils.AnnotationUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.function.Predicate;

public class FieldUtils {
    public static Predicate<Field> ifPublicField = field -> FieldUtils._isPublic(field);
    public static Predicate<Field> ifStaticField = field -> FieldUtils._isStatic(field);
    public static Predicate<Field> ifFinalField = field -> FieldUtils._isFinal(field);

    public static boolean _isPublic(Field field) {
        if (field == null) {
            return false;
        }
        return Modifier.isPublic(field.getModifiers());
    }

    public static boolean _isStatic(Field field) {
        if (field == null) {
            return false;
        }
        return Modifier.isStatic(field.getModifiers());
    }

    public static boolean _isFinal(Field field) {
        if (field == null) {
            return false;
        }
        return Modifier.isFinal(field.getModifiers());
    }

    public static Predicate<Field> annotatedWith(String ... names) {
        return field -> AnnotationUtils.has(field.getAnnotations(), names);
    }
}

