/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.certmanager.decorator;

import io.dekorate.certmanager.annotation.PrivateKeyAlgorithm;
import io.dekorate.certmanager.annotation.PrivateKeyEncoding;
import io.dekorate.certmanager.annotation.RotationPolicy;
import io.dekorate.certmanager.config.CertificateConfig;
import io.dekorate.certmanager.config.IssuerRef;
import io.dekorate.certmanager.config.LocalObjectReference;
import io.dekorate.certmanager.config.Subject;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.utils.Strings;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReference;
import io.fabric8.certmanager.api.model.meta.v1.ObjectReferenceBuilder;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;
import io.fabric8.certmanager.api.model.v1.CertificateBuilder;
import io.fabric8.certmanager.api.model.v1.CertificateFluent;
import io.fabric8.certmanager.api.model.v1.CertificateKeystores;
import io.fabric8.certmanager.api.model.v1.CertificateKeystoresBuilder;
import io.fabric8.certmanager.api.model.v1.CertificateKeystoresFluent;
import io.fabric8.certmanager.api.model.v1.CertificatePrivateKey;
import io.fabric8.certmanager.api.model.v1.CertificatePrivateKeyBuilder;
import io.fabric8.certmanager.api.model.v1.CertificateSpecFluent;
import io.fabric8.certmanager.api.model.v1.X509Subject;
import io.fabric8.certmanager.api.model.v1.X509SubjectBuilder;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;
import java.text.ParseException;
import java.util.Optional;

public class AddCertificateResourceDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    private final CertificateConfig config;

    public AddCertificateResourceDecorator(CertificateConfig config) {
        this.config = config;
    }

    public void visit(KubernetesListBuilder list) {
        HasMetadata meta = this.getMandatoryDeploymentHasMetadata(list, ANY);
        CertificateBuilder builder = new CertificateBuilder();
        ((CertificateFluent.MetadataNested)((CertificateFluent.MetadataNested)builder.withNewMetadata().withName(this.getName(meta))).withNamespace(meta.getMetadata().getNamespace())).endMetadata();
        CertificateFluent.SpecNested spec = (CertificateFluent.SpecNested)builder.withNewSpec().withSecretName(this.config.getSecretName());
        if (this.config.getIssuerRef() != null) {
            spec.withIssuerRef(this.toIssuerRef(this.config.getIssuerRef()));
        } else {
            ((CertificateSpecFluent.IssuerRefNested)spec.withNewIssuerRef().withName(this.getName(meta))).endIssuerRef();
        }
        Optional.ofNullable(this.config.getSubject()).map(this::toSubject).ifPresent(arg_0 -> ((CertificateFluent.SpecNested)spec).withSubject(arg_0));
        Optional.ofNullable(this.config.getCommonName()).ifPresent(arg_0 -> ((CertificateFluent.SpecNested)spec).withCommonName(arg_0));
        Optional.ofNullable(this.config.getDuration()).map(this::toDuration).ifPresent(arg_0 -> ((CertificateFluent.SpecNested)spec).withDuration(arg_0));
        Optional.ofNullable(this.config.getRenewBefore()).map(this::toDuration).ifPresent(arg_0 -> ((CertificateFluent.SpecNested)spec).withRenewBefore(arg_0));
        Optional.ofNullable(this.config.getDnsNames()).ifPresent(arg_0 -> ((CertificateFluent.SpecNested)spec).withDnsNames(arg_0));
        Optional.ofNullable(this.config.getIpAddresses()).ifPresent(arg_0 -> ((CertificateFluent.SpecNested)spec).withIpAddresses(arg_0));
        Optional.ofNullable(this.config.getUris()).ifPresent(arg_0 -> ((CertificateFluent.SpecNested)spec).withUris(arg_0));
        Optional.ofNullable(this.config.getEmailAddresses()).ifPresent(arg_0 -> ((CertificateFluent.SpecNested)spec).withEmailAddresses(arg_0));
        Optional.ofNullable(this.config.getUsages()).ifPresent(arg_0 -> ((CertificateFluent.SpecNested)spec).withUsages(arg_0));
        Optional.ofNullable(this.config.getKeystores()).map(this::toCertificateKeystores).ifPresent(arg_0 -> ((CertificateFluent.SpecNested)spec).withKeystores(arg_0));
        Optional.ofNullable(this.config.getIsCA()).ifPresent(arg_0 -> ((CertificateFluent.SpecNested)spec).withIsCA(arg_0));
        Optional.ofNullable(this.config.getPrivateKey()).map(this::toPrivateKey).ifPresent(arg_0 -> ((CertificateFluent.SpecNested)spec).withPrivateKey(arg_0));
        Optional.ofNullable(this.config.getEncodeUsagesInRequest()).ifPresent(arg_0 -> ((CertificateFluent.SpecNested)spec).withEncodeUsagesInRequest(arg_0));
        list.addToItems(new HasMetadata[]{((CertificateBuilder)spec.endSpec()).build()});
    }

    private CertificatePrivateKey toPrivateKey(io.dekorate.certmanager.config.CertificatePrivateKey privateKey) {
        CertificatePrivateKeyBuilder builder = new CertificatePrivateKeyBuilder();
        if (privateKey.getRotationPolicy() != null && privateKey.getRotationPolicy() != RotationPolicy.Unset) {
            builder.withRotationPolicy(privateKey.getRotationPolicy().name());
        }
        if (privateKey.getAlgorithm() != null && privateKey.getAlgorithm() != PrivateKeyAlgorithm.Unset) {
            builder.withAlgorithm(privateKey.getAlgorithm().name());
        }
        if (privateKey.getEncoding() != null && privateKey.getEncoding() != PrivateKeyEncoding.Unset) {
            builder.withEncoding(privateKey.getEncoding().name());
        }
        if (privateKey.getSize() >= 0) {
            builder.withSize(privateKey.getSize());
        }
        return builder.build();
    }

    private CertificateKeystores toCertificateKeystores(io.dekorate.certmanager.config.CertificateKeystores keystores) {
        CertificateKeystoresBuilder builder = new CertificateKeystoresBuilder();
        if (keystores.getJks() != null) {
            ((CertificateKeystoresFluent.JksNested)((CertificateKeystoresFluent.JksNested)builder.withNewJks().withCreate(keystores.getJks().getCreate())).withPasswordSecretRef(this.toSecretKeySelector(keystores.getJks().getPasswordSecretRef()))).endJks();
        }
        if (keystores.getPkcs12() != null) {
            ((CertificateKeystoresFluent.Pkcs12Nested)((CertificateKeystoresFluent.Pkcs12Nested)builder.withNewPkcs12().withCreate(keystores.getPkcs12().getCreate())).withPasswordSecretRef(this.toSecretKeySelector(keystores.getPkcs12().getPasswordSecretRef()))).endPkcs12();
        }
        return builder.build();
    }

    private SecretKeySelector toSecretKeySelector(LocalObjectReference ref) {
        if (ref == null) {
            return null;
        }
        SecretKeySelectorBuilder builder = new SecretKeySelectorBuilder();
        builder.withName(ref.getName());
        builder.withKey(ref.getKey());
        return builder.build();
    }

    private Duration toDuration(String str) {
        try {
            return Duration.parse((String)str);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Wrong duration format '" + str + "'", e);
        }
    }

    private ObjectReference toIssuerRef(IssuerRef issuerRef) {
        ObjectReferenceBuilder builder = new ObjectReferenceBuilder();
        builder.withName(issuerRef.getName());
        if (Strings.isNotNullOrEmpty((String)issuerRef.getKind())) {
            builder.withKind(issuerRef.getKind());
        }
        if (Strings.isNotNullOrEmpty((String)issuerRef.getGroup())) {
            builder.withGroup(issuerRef.getGroup());
        }
        return builder.build();
    }

    private X509Subject toSubject(Subject s) {
        X509SubjectBuilder builder = new X509SubjectBuilder();
        Optional.ofNullable(s.getCountries()).ifPresent(arg_0 -> ((X509SubjectBuilder)builder).withCountries(arg_0));
        Optional.ofNullable(s.getLocalities()).ifPresent(arg_0 -> ((X509SubjectBuilder)builder).withLocalities(arg_0));
        Optional.ofNullable(s.getOrganizationalUnits()).ifPresent(arg_0 -> ((X509SubjectBuilder)builder).withOrganizationalUnits(arg_0));
        Optional.ofNullable(s.getOrganizations()).ifPresent(arg_0 -> ((X509SubjectBuilder)builder).withOrganizations(arg_0));
        Optional.ofNullable(s.getProvinces()).ifPresent(arg_0 -> ((X509SubjectBuilder)builder).withProvinces(arg_0));
        Optional.ofNullable(s.getPostalCodes()).ifPresent(arg_0 -> ((X509SubjectBuilder)builder).withPostalCodes(arg_0));
        Optional.ofNullable(s.getSerialNumber()).ifPresent(arg_0 -> ((X509SubjectBuilder)builder).withSerialNumber(arg_0));
        Optional.ofNullable(s.getStreetAddresses()).ifPresent(arg_0 -> ((X509SubjectBuilder)builder).withStreetAddresses(arg_0));
        return builder.build();
    }

    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class};
    }

    private String getName(HasMetadata meta) {
        if (Strings.isNullOrEmpty((String)this.config.getName())) {
            return meta.getMetadata().getName();
        }
        return this.config.getName();
    }
}

