/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.certmanager.decorator;

import io.dekorate.certmanager.config.LocalObjectReference;
import io.dekorate.certmanager.config.Vault;
import io.dekorate.certmanager.config.VaultKubernetesAuth;
import io.dekorate.certmanager.decorator.BaseAddIssuerResourceDecorator;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelector;
import io.fabric8.certmanager.api.model.meta.v1.SecretKeySelectorBuilder;
import io.fabric8.certmanager.api.model.v1.IssuerBuilder;
import io.fabric8.certmanager.api.model.v1.IssuerFluent;
import io.fabric8.certmanager.api.model.v1.VaultAppRole;
import io.fabric8.certmanager.api.model.v1.VaultAuthBuilder;
import io.fabric8.certmanager.api.model.v1.VaultIssuerBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

public class AddVaultIssuerResourceDecorator
extends BaseAddIssuerResourceDecorator {
    private final Vault config;

    public AddVaultIssuerResourceDecorator(Vault config, String certificateName) {
        super(certificateName);
        this.config = config;
    }

    @Override
    protected void visitIssuerSpec(IssuerFluent.SpecNested<IssuerBuilder> spec) {
        if (this.noneAuthIsSet(this.config.getAuthAppRole(), this.config.getAuthKubernetes(), this.config.getAuthTokenSecretRef())) {
            throw new IllegalArgumentException("No auth mechanism has been set in the Vault Issuer configuration");
        }
        if (this.moreThanOneAuthIsSet(this.config.getAuthAppRole(), this.config.getAuthKubernetes(), this.config.getAuthTokenSecretRef())) {
            throw new IllegalArgumentException("More than one auth mechanisms have been set in the Vault Issuer configuration");
        }
        VaultIssuerBuilder builder = (VaultIssuerBuilder)((VaultIssuerBuilder)((VaultIssuerBuilder)new VaultIssuerBuilder().withCaBundle(this.config.getCaBundle())).withServer(this.config.getServer())).withPath(this.config.getPath());
        Optional.ofNullable(this.config.getNamespace()).ifPresent(arg_0 -> ((VaultIssuerBuilder)builder).withNamespace(arg_0));
        VaultAuthBuilder authBuilder = new VaultAuthBuilder();
        Optional.ofNullable(this.config.getAuthTokenSecretRef()).ifPresent(r -> {
            VaultAuthBuilder cfr_ignored_0 = (VaultAuthBuilder)authBuilder.withTokenSecretRef(this.toSecretKeySelector((LocalObjectReference)r));
        });
        Optional.ofNullable(this.config.getAuthKubernetes()).ifPresent(r -> {
            VaultAuthBuilder cfr_ignored_0 = (VaultAuthBuilder)authBuilder.withKubernetes(this.toVaultKubernetesAuth((VaultKubernetesAuth)r));
        });
        Optional.ofNullable(this.config.getAuthAppRole()).ifPresent(r -> {
            VaultAuthBuilder cfr_ignored_0 = (VaultAuthBuilder)authBuilder.withAppRole(this.toVaultAppRole((io.dekorate.certmanager.config.VaultAppRole)r));
        });
        builder.withAuth(authBuilder.build());
        spec.withVault(builder.build());
    }

    private VaultAppRole toVaultAppRole(io.dekorate.certmanager.config.VaultAppRole config) {
        VaultAppRole auth = new VaultAppRole();
        auth.setPath(config.getPath());
        auth.setRoleId(config.getRoleId());
        if (config.getSecretRef() != null) {
            auth.setSecretRef(this.toSecretKeySelector(config.getSecretRef()));
        }
        return auth;
    }

    private io.fabric8.certmanager.api.model.v1.VaultKubernetesAuth toVaultKubernetesAuth(VaultKubernetesAuth config) {
        io.fabric8.certmanager.api.model.v1.VaultKubernetesAuth auth = new io.fabric8.certmanager.api.model.v1.VaultKubernetesAuth();
        auth.setMountPath(config.getMountPath());
        auth.setRole(config.getRole());
        if (config.getSecretRef() != null) {
            auth.setSecretRef(this.toSecretKeySelector(config.getSecretRef()));
        }
        return auth;
    }

    private SecretKeySelector toSecretKeySelector(LocalObjectReference config) {
        return ((SecretKeySelectorBuilder)((SecretKeySelectorBuilder)new SecretKeySelectorBuilder().withName(config.getName())).withKey(config.getKey())).build();
    }

    private boolean moreThanOneAuthIsSet(Object ... auths) {
        return Stream.of(auths).filter(Objects::nonNull).count() > 1L;
    }

    private boolean noneAuthIsSet(Object ... auths) {
        return Stream.of(auths).noneMatch(Objects::nonNull);
    }
}

