/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.certmanager.decorator;

import io.dekorate.certmanager.decorator.AddCertificateResourceDecorator;
import io.dekorate.kubernetes.decorator.Decorator;
import io.dekorate.kubernetes.decorator.ResourceProvidingDecorator;
import io.dekorate.utils.Strings;
import io.fabric8.certmanager.api.model.v1.IssuerBuilder;
import io.fabric8.certmanager.api.model.v1.IssuerFluent;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesListBuilder;

public abstract class BaseAddIssuerResourceDecorator
extends ResourceProvidingDecorator<KubernetesListBuilder> {
    private final String certificateName;

    protected abstract void visitIssuerSpec(IssuerFluent.SpecNested<IssuerBuilder> var1);

    public BaseAddIssuerResourceDecorator(String certificateName) {
        this.certificateName = certificateName;
    }

    public void visit(KubernetesListBuilder list) {
        HasMetadata meta = this.getMandatoryDeploymentHasMetadata(list, ANY);
        IssuerBuilder builder = new IssuerBuilder();
        ((IssuerFluent.MetadataNested)((IssuerFluent.MetadataNested)builder.withNewMetadata().withName(this.getName(meta))).withNamespace(meta.getMetadata().getNamespace())).endMetadata();
        IssuerFluent.SpecNested spec = builder.withNewSpec();
        this.visitIssuerSpec((IssuerFluent.SpecNested<IssuerBuilder>)spec);
        list.addToItems(new HasMetadata[]{((IssuerBuilder)spec.endSpec()).build()});
    }

    public Class<? extends Decorator>[] after() {
        return new Class[]{ResourceProvidingDecorator.class};
    }

    public Class<? extends Decorator>[] before() {
        return new Class[]{AddCertificateResourceDecorator.class};
    }

    private String getName(HasMetadata meta) {
        if (Strings.isNullOrEmpty((String)this.certificateName)) {
            return meta.getMetadata().getName();
        }
        return this.certificateName;
    }
}

