/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.certmanager.config;

import io.dekorate.certmanager.config.CA;
import io.dekorate.certmanager.config.CertificateConfigBuilder;
import io.dekorate.certmanager.config.CertificateKeystores;
import io.dekorate.certmanager.config.CertificatePrivateKey;
import io.dekorate.certmanager.config.IssuerRef;
import io.dekorate.certmanager.config.SelfSigned;
import io.dekorate.certmanager.config.Subject;
import io.dekorate.certmanager.config.Vault;
import io.dekorate.kubernetes.config.ConfigKey;
import io.dekorate.kubernetes.config.Configuration;
import io.dekorate.project.Project;
import java.util.Map;
import java.util.Objects;

public class CertificateConfig
extends Configuration {
    private String name;
    private String secretName;
    private IssuerRef issuerRef;
    private CA ca;
    private Vault vault;
    private SelfSigned selfSigned;
    private Subject subject;
    private String commonName;
    private String duration;
    private String renewBefore;
    private String[] dnsNames = new String[0];
    private String[] ipAddresses = new String[0];
    private String[] uris = new String[0];
    private String[] emailAddresses = new String[0];
    private CertificateKeystores keystores;
    private Boolean isCA;
    private String[] usages = new String[0];
    private CertificatePrivateKey privateKey;
    private Boolean encodeUsagesInRequest;
    private String volumeMountPath;

    public CertificateConfig() {
    }

    public CertificateConfig(Project project, Map<ConfigKey, Object> attributes, String name, String secretName, IssuerRef issuerRef, CA ca, Vault vault, SelfSigned selfSigned, Subject subject, String commonName, String duration, String renewBefore, String[] dnsNames, String[] ipAddresses, String[] uris, String[] emailAddresses, CertificateKeystores keystores, Boolean isCA, String[] usages, CertificatePrivateKey privateKey, Boolean encodeUsagesInRequest, String volumeMountPath) {
        super(project, attributes);
        this.name = name;
        this.secretName = secretName;
        this.issuerRef = issuerRef;
        this.ca = ca;
        this.vault = vault;
        this.selfSigned = selfSigned;
        this.subject = subject;
        this.commonName = commonName;
        this.duration = duration;
        this.renewBefore = renewBefore;
        this.dnsNames = dnsNames != null ? dnsNames : new String[]{};
        this.ipAddresses = ipAddresses != null ? ipAddresses : new String[]{};
        this.uris = uris != null ? uris : new String[]{};
        this.emailAddresses = emailAddresses != null ? emailAddresses : new String[]{};
        this.keystores = keystores;
        this.isCA = isCA;
        this.usages = usages != null ? usages : new String[]{};
        this.privateKey = privateKey;
        this.encodeUsagesInRequest = encodeUsagesInRequest;
        this.volumeMountPath = volumeMountPath;
    }

    public String getName() {
        return this.name;
    }

    public String getSecretName() {
        return this.secretName;
    }

    public IssuerRef getIssuerRef() {
        return this.issuerRef;
    }

    public CA getCa() {
        return this.ca;
    }

    public Vault getVault() {
        return this.vault;
    }

    public SelfSigned getSelfSigned() {
        return this.selfSigned;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public String getDuration() {
        return this.duration;
    }

    public String getRenewBefore() {
        return this.renewBefore;
    }

    public String[] getDnsNames() {
        return this.dnsNames;
    }

    public String[] getIpAddresses() {
        return this.ipAddresses;
    }

    public String[] getUris() {
        return this.uris;
    }

    public String[] getEmailAddresses() {
        return this.emailAddresses;
    }

    public CertificateKeystores getKeystores() {
        return this.keystores;
    }

    public Boolean getIsCA() {
        return this.isCA;
    }

    public boolean isIsCA() {
        return this.isCA != null && this.isCA != false;
    }

    public String[] getUsages() {
        return this.usages;
    }

    public CertificatePrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public Boolean getEncodeUsagesInRequest() {
        return this.encodeUsagesInRequest;
    }

    public boolean isEncodeUsagesInRequest() {
        return this.encodeUsagesInRequest != null && this.encodeUsagesInRequest != false;
    }

    public String getVolumeMountPath() {
        return this.volumeMountPath;
    }

    public static CertificateConfigBuilder newCertificateConfigBuilder() {
        return new CertificateConfigBuilder();
    }

    public static CertificateConfigBuilder newCertificateConfigBuilderFromDefaults() {
        return (CertificateConfigBuilder)((Object)((CertificateConfigBuilder)((Object)((CertificateConfigBuilder)((Object)((CertificateConfigBuilder)((Object)((CertificateConfigBuilder)((Object)((CertificateConfigBuilder)((Object)((CertificateConfigBuilder)((Object)((CertificateConfigBuilder)((Object)((CertificateConfigBuilder)((Object)new CertificateConfigBuilder().withIssuerRef(new IssuerRef()))).withCa(new CA()))).withVault(new Vault()))).withSelfSigned(new SelfSigned()))).withSubject(new Subject()))).withKeystores(new CertificateKeystores()))).withIsCA(false))).withPrivateKey(new CertificatePrivateKey()))).withEncodeUsagesInRequest(false));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CertificateConfig that = (CertificateConfig)((Object)o);
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.secretName, that.secretName)) {
            return false;
        }
        if (!Objects.equals(this.issuerRef, that.issuerRef)) {
            return false;
        }
        if (!Objects.equals(this.ca, that.ca)) {
            return false;
        }
        if (!Objects.equals(this.vault, that.vault)) {
            return false;
        }
        if (!Objects.equals(this.selfSigned, that.selfSigned)) {
            return false;
        }
        if (!Objects.equals(this.subject, that.subject)) {
            return false;
        }
        if (!Objects.equals(this.commonName, that.commonName)) {
            return false;
        }
        if (!Objects.equals(this.duration, that.duration)) {
            return false;
        }
        if (!Objects.equals(this.renewBefore, that.renewBefore)) {
            return false;
        }
        if (!Objects.equals(this.dnsNames, that.dnsNames)) {
            return false;
        }
        if (!Objects.equals(this.ipAddresses, that.ipAddresses)) {
            return false;
        }
        if (!Objects.equals(this.uris, that.uris)) {
            return false;
        }
        if (!Objects.equals(this.emailAddresses, that.emailAddresses)) {
            return false;
        }
        if (!Objects.equals(this.keystores, that.keystores)) {
            return false;
        }
        if (!Objects.equals(this.isCA, that.isCA)) {
            return false;
        }
        if (!Objects.equals(this.usages, that.usages)) {
            return false;
        }
        if (!Objects.equals(this.privateKey, that.privateKey)) {
            return false;
        }
        if (!Objects.equals(this.encodeUsagesInRequest, that.encodeUsagesInRequest)) {
            return false;
        }
        return Objects.equals(this.volumeMountPath, that.volumeMountPath);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.secretName, this.issuerRef, this.ca, this.vault, this.selfSigned, this.subject, this.commonName, this.duration, this.renewBefore, this.dnsNames, this.ipAddresses, this.uris, this.emailAddresses, this.keystores, this.isCA, this.usages, this.privateKey, this.encodeUsagesInRequest, this.volumeMountPath, super.hashCode());
    }
}

