/*
 * Decompiled with CFR 0.152.
 */
package io.dekorate.certmanager.config;

import io.dekorate.certmanager.config.LocalObjectReference;
import io.dekorate.certmanager.config.LocalObjectReferenceBuilder;
import io.dekorate.certmanager.config.LocalObjectReferenceFluent;
import io.dekorate.certmanager.config.VaultKubernetesAuth;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Objects;
import java.util.Optional;

public class VaultKubernetesAuthFluent<A extends VaultKubernetesAuthFluent<A>>
extends BaseFluent<A> {
    private String mountPath;
    private String role;
    private LocalObjectReferenceBuilder secretRef;

    public VaultKubernetesAuthFluent() {
    }

    public VaultKubernetesAuthFluent(VaultKubernetesAuth instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(VaultKubernetesAuth instance) {
        VaultKubernetesAuth vaultKubernetesAuth = instance = instance != null ? instance : new VaultKubernetesAuth();
        if (instance != null) {
            this.withMountPath(instance.getMountPath());
            this.withRole(instance.getRole());
            this.withSecretRef(instance.getSecretRef());
        }
    }

    public String getMountPath() {
        return this.mountPath;
    }

    public A withMountPath(String mountPath) {
        this.mountPath = mountPath;
        return (A)((Object)this);
    }

    public boolean hasMountPath() {
        return this.mountPath != null;
    }

    public String getRole() {
        return this.role;
    }

    public A withRole(String role) {
        this.role = role;
        return (A)((Object)this);
    }

    public boolean hasRole() {
        return this.role != null;
    }

    public LocalObjectReference buildSecretRef() {
        return this.secretRef != null ? this.secretRef.build() : null;
    }

    public A withSecretRef(LocalObjectReference secretRef) {
        this._visitables.remove((Object)"secretRef");
        if (secretRef != null) {
            this.secretRef = new LocalObjectReferenceBuilder(secretRef);
            this._visitables.get((Object)"secretRef").add(this.secretRef);
        } else {
            this.secretRef = null;
            this._visitables.get((Object)"secretRef").remove((Object)this.secretRef);
        }
        return (A)((Object)this);
    }

    public boolean hasSecretRef() {
        return this.secretRef != null;
    }

    public A withNewSecretRef(String name, String key) {
        return this.withSecretRef(new LocalObjectReference(name, key));
    }

    public SecretRefNested<A> withNewSecretRef() {
        return new SecretRefNested(null);
    }

    public SecretRefNested<A> withNewSecretRefLike(LocalObjectReference item) {
        return new SecretRefNested(item);
    }

    public SecretRefNested<A> editSecretRef() {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(null));
    }

    public SecretRefNested<A> editOrNewSecretRef() {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(new LocalObjectReferenceBuilder().build()));
    }

    public SecretRefNested<A> editOrNewSecretRefLike(LocalObjectReference item) {
        return this.withNewSecretRefLike(Optional.ofNullable(this.buildSecretRef()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        VaultKubernetesAuthFluent that = (VaultKubernetesAuthFluent)((Object)o);
        if (!Objects.equals(this.mountPath, that.mountPath)) {
            return false;
        }
        if (!Objects.equals(this.role, that.role)) {
            return false;
        }
        return Objects.equals((Object)this.secretRef, (Object)that.secretRef);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.mountPath, this.role, this.secretRef, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.mountPath != null) {
            sb.append("mountPath:");
            sb.append(this.mountPath + ",");
        }
        if (this.role != null) {
            sb.append("role:");
            sb.append(this.role + ",");
        }
        if (this.secretRef != null) {
            sb.append("secretRef:");
            sb.append((Object)this.secretRef);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SecretRefNested<N>
    extends LocalObjectReferenceFluent<SecretRefNested<N>>
    implements Nested<N> {
        LocalObjectReferenceBuilder builder;

        SecretRefNested(LocalObjectReference item) {
            this.builder = new LocalObjectReferenceBuilder(this, item);
        }

        public N and() {
            return (N)VaultKubernetesAuthFluent.this.withSecretRef(this.builder.build());
        }

        public N endSecretRef() {
            return this.and();
        }
    }
}

